% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reduce,data.frame-method}
\alias{reduce,data.frame-method}
\title{Reduce a data.frame}
\usage{
\S4method{reduce}{data.frame}(x, key, sep = ";")
}
\arguments{
\item{x}{A \code{data.frame}.}

\item{key}{The column name (currenly only one is supported) to be
used as primary key.}

\item{sep}{The separator. Default is \code{;}.}
}
\value{
A reduced \code{data.frame}.
}
\description{
Reduce a data.frame so that the (primary) key column contains only
unique entries and other columns pertaining to that entry are
combined into semicolon-separated values into a single
row/observation.

An important side-effect of reducing a \code{data.frame} is that all
columns other than the key are converted to characters when they
are collapsed to a semi-column separated value (even if only one
value is present) as soon as one observation of transformed.
}
\examples{
dfr <- data.frame(A = c(1, 1, 2),
                  B = c("x", "x", "z"),
                  C = LETTERS[1:3])
dfr
dfr2 <- reduce(dfr, key = "A")
dfr2
## column A used as key is still num
str(dfr2)
dfr3 <- reduce(dfr, key = "B")
dfr3
## A is converted to chr; B remains factor
str(dfr3)
dfr4 <- data.frame(A = 1:3,
                   B = LETTERS[1:3],
                   C = c(TRUE, FALSE, NA))
## No effect of reducing, column classes are maintained
str(reduce(dfr4, key = "B"))
}
\author{
Laurent Gatto
}
