% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-addIdentificationData.R
\name{readMzIdData}
\alias{readMzIdData}
\alias{coerce,mzRident,data.frame-method}
\title{Import peptide-spectrum matches}
\usage{
readMzIdData(files)
}
\arguments{
\item{files}{A \code{character} of \code{mzid} files.}
}
\value{
A \code{data.frame} containing the PSMs stored in the \code{mzId}
files.
}
\description{
Reads as set of \code{mzId} files containing PSMs an generates a
\code{data.frame}.
}
\details{
This function uses the functionality provided by the \code{mzR} package
to access data in the \code{mzId} files. An object of class \code{mzRident}
can also be coerced to a \code{data.frame} using \code{as(, "data.frame")}.
}
\examples{
idf <- "TMT_Erwinia_1uLSike_Top10HCD_isol2_45stepped_60min_01-20141210.mzid"
f <- msdata::ident(full.names = TRUE, pattern = idf)
basename(f)
readMzIdData(f)
}
\seealso{
\code{\link[=filterIdentificationDataFrame]{filterIdentificationDataFrame()}} to filter out unreliable PSMs.
}
\author{
Laurent Gatto
}
