% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonmat2pnps.R
\name{codonmat2pnps}
\alias{codonmat2pnps}
\title{codonmat2pnps}
\usage{
codonmat2pnps(codonmat)
}
\arguments{
\item{codonmat}{\code{codon matrix} of two columns to be
compared [mandatory]}
}
\value{
An object of class \code{pnps} which is a list with the following
components:\cr
\code{seq1} sequence1 name\cr
\code{seq2} sequence2 name\cr
\code{Codons} sequence2 name\cr
\code{Compared} sequence2 name\cr
\code{Ambigiuous} sequence2 name\cr
\code{Indels} sequence2 name\cr
\code{Ns} sequence2 name\cr
\code{Sd} sequence2 name\cr
\code{Sn} sequence2 name\cr
\code{S} sequence2 name\cr
\code{N} sequence2 name\cr
\code{ps} sequence2 name\cr
\code{pn} sequence2 name\cr
\code{pnps} sequence2 name\cr
\code{ds} sequence2 name\cr
\code{dn} sequence2 name\cr
\code{dnds} sequence2 name\cr
}
\description{
This function calculates pn/ps according to \emph{Nei and
Gojobori (1986)}.
}
\examples{
## load example sequence data
data("hiv", package="MSA2dist")
#codonmat2pnps(dnastring2codonmat(hiv)[,c(1, 2)])
(hiv |> dnastring2codonmat())[,c(1, 2)] |> codonmat2pnps()
}
\references{
Nei and Gojobori. (1986) Simple methods for estimating the
numbers of synonymous and nonsynonymous nucleotide substitutions.
\emph{Mol. Biol. Evol.}, \bold{3(5)}, 418-426.

Ganeshan et al. (1997) Human immunodeficiency virus type 1
genetic evolution in children with different rates of development of disease.
\emph{J. Virology.} \bold{71(1)}, 663-677.

Yang et al. (2000) Codon-substitution models for heterogeneous
selection pressure at amino acid sites. \emph{Genetics.}
\bold{155(1)}, 431-449.
}
\seealso{
\code{\link[seqinr]{kaks}}
}
\author{
Kristian K Ullrich
}
