# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @useDynLib MSA2dist, .registration = TRUE
#' @import Rcpp
#' @title rcpp_KaKs
#' @name rcpp_KaKs
#' @description calculates KaKs as implememted in
#' KaKs Calculator 2.0 \code{MSA2dist} with \code{Rcpp}.
#' @return \code{list}
#' @param cdsstr StringVector [mandatory]
#' @param sgc standard genetic code to use [default: 1]
#' @param method KaKs Calculator 2.0 codon model [default: YN]
#' @param verbose specify if verbose output [default: FALSE]
#' @references Wang et al. (2010) KaKs_Calculator 2.0: a toolkit incorporating
#' gamma-series methods and sliding window strategies.\emph{Genomics,
#' proteomics & bioinformatics.} \bold{8(1)}, 77-80.
#' @examples
#' ## load example sequence data
#' data("hiv", package="MSA2dist")
#' rcpp_KaKs(cdsstr=as.character(hiv[1:3]))
#' @export rcpp_KaKs
#' @author Kristian K Ullrich
rcpp_KaKs <- function(cdsstr, sgc = "1", method = "YN", verbose = FALSE) {
    .Call(`_MSA2dist_rcpp_KaKs`, cdsstr, sgc, method, verbose)
}

#' @useDynLib MSA2dist, .registration = TRUE
#' @import Rcpp
#' @title rcpp_distSTRING
#' @name rcpp_distSTRING
#' @description calculates pairwise distances using a score matrix
#' @return list
#' @param dnavector StringVector [mandatory]
#' @param scoreMatrix NumericMatrix [mandatory]
#' @param ncores number of cores [default: 1]
#' @param symmetric symmetric score matrix [default: 1]
#' @examples
#' ## load example sequence data
#' data("hiv", package="MSA2dist")
#' rcpp_distSTRING(dnavector=as.character(hiv), scoreMatrix=iupacMatrix())
#' @export rcpp_distSTRING
#' @author Kristian K Ullrich
rcpp_distSTRING <- function(dnavector, scoreMatrix,
    ncores = 1L, symmetric = 1L) {
    .Call(`_MSA2dist_rcpp_distSTRING`, dnavector, scoreMatrix,
    ncores, symmetric)
}

#' @useDynLib MSA2dist, .registration = TRUE
#' @import Rcpp
#' @title rcpp_pairwiseDeletionAA
#' @name rcpp_pairwiseDeletionAA
#' @description returns number of AA sites used
#' @return list
#' @param aavector StringVector [mandatory]
#' @param ncores number of cores [default: 1]
#' @param symmetric symmetric score matrix [default: 1]
#' @examples
#' ## load example sequence data
#' data("hiv", package="MSA2dist")
#' h <- hiv |> cds2aa() |> as.character()
#' rcpp_pairwiseDeletionAA(aavector=h, ncores=1)
#' @export rcpp_pairwiseDeletionAA
#' @author Kristian K Ullrich
rcpp_pairwiseDeletionAA <- function(aavector, ncores = 1L, symmetric = 1L) {
    .Call(`_MSA2dist_rcpp_pairwiseDeletionAA`, aavector, ncores, symmetric)
}

#' @useDynLib MSA2dist, .registration = TRUE
#' @import Rcpp
#' @title rcpp_pairwiseDeletionDNA
#' @name rcpp_pairwiseDeletionDNA
#' @description returns number of DNA sites used
#' @return list
#' @param dnavector StringVector [mandatory]
#' @param ncores number of cores [default: 1]
#' @param symmetric symmetric score matrix [default: 1]
#' @examples
#' ## load example sequence data
#' data("woodmouse", package="ape")
#' w <- woodmouse |> dnabin2dnastring() |> as.character()
#' rcpp_pairwiseDeletionDNA(dnavector=w, ncores=1)
#' @export rcpp_pairwiseDeletionDNA
#' @author Kristian K Ullrich
rcpp_pairwiseDeletionDNA <- function(dnavector, ncores = 1L, symmetric = 1L) {
    .Call(`_MSA2dist_rcpp_pairwiseDeletionDNA`, dnavector, ncores, symmetric)
}

