% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesisTesting.R
\name{testCoefficient}
\alias{testCoefficient}
\title{Calculate the significance of a factor in the regression model}
\usage{
testCoefficient(obj, factor, contrast)
}
\arguments{
\item{obj}{the MpraObject}

\item{factor}{the name of the factor to make the comparison on}

\item{contrast}{the character value of the factor to use as a contrast. See 
details.}
}
\value{
a data.frame of the results
this include the test statistic, logFC, p-value and BH-corrected FDR.
}
\description{
Calculate the significance of a factor in the regression model
}
\examples{
data <- simulateMPRA(tr = rep(2,5), da=c(rep(0,2), rep(1,3)), 
                     nbatch=2, nbc=15)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")

## fit.se must be TRUE for coefficient based testing to work
obj <- analyzeComparative(obj, dnaDesign = ~ batch + barcode + condition, 
                              rnaDesign = ~ condition, fit.se = TRUE)
results <- testCoefficient(obj, "condition", "contrast")
}
