% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{scrna}
\alias{scrna}
\title{Data to test scMOSim}
\format{
A seurat Object, subset from seuratData with RNA
 \describe{
     \item{assays}{RNA expression values}
     \item{meta.data}{annotations of celltypes}
     }
     
 @source {https://github.com/satijalab/seurat-data, we took 11 cells 
 from each of 4 celltypes}
 This is how:
 dat <- pbmcMultiome.SeuratData::pbmc.rna
 dat <- subset(x = dat, subset = seurat_annotations %in% c("CD4 TEM", 
                                                           "cDC", "Memory B", "Treg"))
 unique_cell_types <- unique(datATmeta.data$seurat_annotations)
 extracted_cells <- list()
 cellnames <- c()
 for (cell_type in unique_cell_types) {
   type_cells <- subset(dat, subset = seurat_annotations %in% cell_type)
   counts <- as.matrix(type_cellsATassays[["RNA"]]ATcounts)
   extracted_cells[[cell_type]] <- counts[, 1:10]
   cellnames <- append(cellnames, replicate(11, cell_type))
 }
 scrna <- Reduce(cbind, extracted_cells)
}
\usage{
data("scrna")
}
\description{
Data to test scMOSim
}
