% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supertest&frequencyplot.R
\name{computeOmicsIntersections}
\alias{computeOmicsIntersections}
\title{Compute Omics Intersections}
\usage{
computeOmicsIntersections(
  multiPathwayReportData,
  pvalueThr = 0.05,
  zscoreThr = 0.05,
  resampligThr = NULL,
  excludeColumns = NULL
)
}
\arguments{
\item{multiPathwayReportData}{data.frame, the output of the
\code{\link{multiPathwayReport}} or \code{\link{multiPathwayModuleReport}}
functions.}

\item{pvalueThr}{numeric value. Overall pvalue cut-off to be used}

\item{zscoreThr}{numeric value. Covariates coefficient cut-off to be used.}

\item{resampligThr}{numeric value. Filters the modules according to the
number of success in the resampling procedure, takes only the modules above
this threshold.}

\item{excludeColumns}{a vector of characters listing the columns of
\code{multiPathwayReportData} object to be excluded by the analysis.
In the case \code{multiPathwayReportData} derives from
\code{\link{multiPathwayModuleReport}}
you should set \code{excludeColumns = c('pathway','module')}.}
}
\value{
a list of pathway modules present for every intersection of omics
present
}
\description{
Finds the modules that have any intersection among the available omics
}
\examples{
df <- data.frame(
    pvalue = c(0.06, 0.04, 0.04, 0.03, 0.02),
    cnv = c(0.07, 0.03, 0.02, 0.04, 0.01),
    mut = c(0.08, 0.02, 0.01, 0.04, 0.04),
    row.names = c(
        "PathwayA", "PathwayB", "PathwayC",
        "PathwayD", "PathwayE"
    )
)

omicsClasses2Pathways <- computeOmicsIntersections(df,
    pvalueThr = 0.1,
    zscoreThr = 0.1
)

}
