% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODA.R
\name{comparemodulestwonets}
\alias{comparemodulestwonets}
\title{Illustration of two networks comparison}
\usage{
comparemodulestwonets(sourcehead, nm1, nm2, ind1, ind2)
}
\arguments{
\item{sourcehead}{prefix of where to store results}

\item{nm1}{how many modules in the background network}

\item{nm2}{how many modules in the condition-specific network}

\item{ind1}{indicator of the background network}

\item{ind2}{indicator of the condition-specific network}
}
\value{
A matrix where each entry is the Jaccard index of corresponding 
modules from two networks
}
\description{
Compare the background network and a condition-specific network. A Jaccard
index is used to measure the similarity of two sets, which represents the 
similarity of each module pairs from two networks.
}
\examples{
data(synthetic)
ResultFolder = 'ForSynthetic' # where middle files are stored
CuttingCriterion = 'Density' # could be Density or Modularity
indicator1 = 'X'     # indicator for data profile 1
indicator2 = 'Y'      # indicator for data profile 2
intModules1 <- WeightedModulePartitionHierarchical(datExpr1,ResultFolder,
indicator1,CuttingCriterion) 
intModules2 <- WeightedModulePartitionHierarchical(datExpr2,ResultFolder,
indicator2,CuttingCriterion) 
JaccardMatrix <- comparemodulestwonets(ResultFolder,intModules1,intModules2,
paste('/DenseModuleGene_',indicator1,sep=''),
paste('/DenseModuleGene_',indicator2,sep=''))

}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\keyword{comparison}
\keyword{module}

