% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotDimensions}
\alias{plotDimensions}
\title{Generate multidimensional scaling (MDS) plots to explore miRNA/gene
expression distances}
\usage{
plotDimensions(
  mirnaObj,
  assay,
  condition = NULL,
  dimensions = c(1, 2),
  labels = FALSE,
  boxedLabel = TRUE,
  pointSize = 3,
  pointAlpha = 1,
  colorScale = NULL,
  title = NULL,
  fontSize = 12,
  fontFamily = "",
  legend = "top",
  borderWidth = 1,
  allBorders = TRUE,
  grid = FALSE,
  ...
)
}
\arguments{
\item{mirnaObj}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object
containing miRNA and gene data}

\item{assay}{The results to display. It must be either 'microRNA', to plot
miRNA expression, or 'genes', to produce MDS plot for genes}

\item{condition}{It must be the column name of a variable specified in the
metadata (colData) of a \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object;
or, alternatively, it must be a character/factor object that specifies
group memberships (eg. c("healthy, "healthy", "disease", "disease"))}

\item{dimensions}{It is a numeric vector of length 2 that indicates the two
dimensions to represent on the plot. Default is \code{c(1, 2)} to plot the two
dimensions that account for the highest portion of variability}

\item{labels}{Logical, whether to display labels or not. Default is FALSE}

\item{boxedLabel}{Logical, whether to show labels inside a rectangular shape
(default) or just as text elements}

\item{pointSize}{The size of points in the MDS plot (default is 3)}

\item{pointAlpha}{The transparency of points in the MDS plot (default
is 1)}

\item{colorScale}{It must be a named character vector where values
correspond to R colors, while names coincide with the groups specified in
the \code{condition} parameter (eg. c("healthy" = "green", "disease" = "red")).
Default is NULL, in order to use the default color scale. Available color
formats include color names, such as 'blue' and 'red', and hexadecimal
colors specified as #RRGGBB}

\item{title}{The title of the plot. Default is \code{NULL} not to include a plot
title}

\item{fontSize}{The base size for text elements within the plot.
Default is 12}

\item{fontFamily}{The base family for text elements within the plot}

\item{legend}{The position of the legend. Allowed values are \code{top},
\code{bottom}, \code{right}, \code{left} and \code{none}. The default setting is \code{top} to show
a legend above the plot. If \code{none} is specified, the legend will not be
included in the graph.}

\item{borderWidth}{The width of plot borders (default is 1)}

\item{allBorders}{Logical, whetether to show all panel borders, or just the
bottom and left borders. Default is TRUE}

\item{grid}{Logical, whether to show grid lines or not. Default is FALSE}

\item{...}{Other parameters that can be passed to \code{\link[limma:plotMDS]{limma::plotMDS()}} function}
}
\value{
An object of class \code{ggplot} containing the plot.
}
\description{
This function performs multidimensional scaling in order to produce a simple
scatterplot that shows miRNA/gene expression variations among samples. In
particular, starting from a \code{\link[=MirnaExperiment-class]{MirnaExperiment}}
object, this functions allows to visualize both miRNA and gene expression in
the multidimensional space. Moreover, it is possible to color samples on the
basis of specific variables, and this is extremely useful to assess
miRNA/gene expression variations between distinct biological groups.
}
\note{
To perform multidimensional scaling, this function internally uses
\code{\link[limma:plotMDS]{limma::plotMDS()}} function provided by \code{limma} package.
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# produce MDS plot for genes with condition color
plotDimensions(obj, "genes", condition = "disease")

}
\references{
Ritchie ME, Phipson B, Wu D, Hu Y, Law CW, Shi W, Smyth GK (2015). “limma
powers differential expression analyses for RNA-sequencing and microarray
studies.” Nucleic Acids Research, 43(7), e47. \url{doi:10.1093/nar/gkv007}.
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
