% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_plots.R
\name{mbecSCOEFStatsPlot}
\alias{mbecSCOEFStatsPlot}
\title{Plot Silhouette Coefficient}
\usage{
mbecSCOEFStatsPlot(scoef.obj)
}
\arguments{
\item{scoef.obj, }{output of 'mbecVarianceStats' with method s.coef}
}
\value{
A ggplot2 dot-plot object.
}
\description{
The goodness of clustering assessed by the silhouette coefficient.
It works with the output of 'mbecVarianceStats()' for the method 's.coef'.
Format of this output is a data.frame that contains a column for every model
variable and as many rows as there are features (OTUs, Genes, ..). Multiple
frames may be used as input by putting them into a list - IF the data.frames
contain a column named 'type', this function will use 'facet_grid()' to
display side-by-side panels to enable easy comparison.
}
\examples{
# This will return a paneled plot that shows results for the variance
# assessment.
data(dummy.mbec)
df.var.scoef <- mbecModelVariance(input.obj=dummy.mbec,
model.vars=c('batch','group'), method='s.coef', type='clr')
plot.scoef <- mbecSCOEFStatsPlot(scoef.obj=df.var.scoef)
}
\keyword{linear}
\keyword{mixed}
\keyword{models}
\keyword{plot}
\keyword{proportion}
\keyword{variance}
