% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_helper.R
\name{mbecExplainedVariance}
\alias{mbecExplainedVariance}
\title{Calculate explained variance using CCA}
\usage{
mbecExplainedVariance(input.mtx, var.mtx, n.comp = ncol(var.mtx))
}
\arguments{
\item{input.mtx}{A matrix of counts (samples x features).}

\item{var.mtx}{An 'sxcomponents' matrix object of orthogonal components that
explain the variance in input.mtx}

\item{n.comp}{Number of columns in var.mtx that should be used. Defaults to
the total number of columns in var.mtx.}
}
\value{
A vector that contains the proportional variance explained for each
selected component in var.mtx.
}
\description{
Internal function that performs Canonical Correspondence Analysis to compute
the proportion of explained variance the can be attributed to a set of given
components.
}
\keyword{cca}
\keyword{explained}
\keyword{variance}
