% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{colinScore}
\alias{colinScore}
\title{Variable Correlation Linear (Mixed) Models}
\usage{
colinScore(model.fit)
}
\arguments{
\item{model.fit}{lm() or lmm() output}
}
\value{
Maximum amount of correlation for given model variables.
}
\description{
Takes a fitted model and computes maximum correlation between covariates as
return value. Return value contains actual correlation-matrix as 'vcor'
attribute.
}
\details{
ToDo: maybe some additional validation steps and more informative output.
}
\examples{
# This will return the maximum colinearity score in the given model
data(dummy.list)
limimo <- lme4::lmer(dummy.list$cnts[,1] ~ group + (1|batch),
data=dummy.list$meta)
num.max_corr <- colinScore(model.fit=limimo)
}
\keyword{collinearity}
\keyword{model}
\keyword{validation}
