% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getMuRho}
\alias{getAB}
\alias{getMuRho}
\title{Functions to convert between shape parameters a and b for beta distribution and parameters mu (mean) and rho (dispersion).}
\usage{
getMuRho(a, b, checkArgs = FALSE)

getAB(mu, rho, checkArgs = FALSE)
}
\arguments{
\item{a,b}{shape parameters for beta distribution. Must be >0.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}

\item{mu,rho}{mean and dispersion parameters for beta distribution, respectively. Must be in (0,1) interval, although rho is allowed to take on value of 0 (binomial distribution).}
}
\value{
getMuRho returns a list with 2 elements: mu and rho (vectors, if the arguments a and b are vectors).

getAB returns a list with 2 elements: a and b (vectors, if arguments mu and rho are vectors). For values of rho=0, the resulting entries are NA.
}
\description{
Functions to convert between shape parameters a and b for beta distribution and parameters mu (mean) and rho (dispersion).


}
\details{
getMuRho takes in shape parameters a and b and returns list with parameters mu (a/(a+b)) and rho (1/(a+b+1)). The function is vectorized (both a and b can be vectors (of the same length) or matrices (of the same dimension)).

getAB takes in shape mean and dispersion parameters mu and rho and returns shape parameters a (mu*(1/rho-1)) and b ((1-mu)*(1/rho-1)). The function is vectorized (both mu and rho can be vectors (of the same length) or matrices (of the same dimension)).
}
\examples{
MBASED:::getMuRho(a=1, b=1)
MBASED:::getAB(mu=1/2, rho=1/3)
MBASED:::getMuRho(MBASED:::getAB(mu=0.7, rho=0.0045)$a, MBASED:::getAB(mu=0.7, rho=0.0045)$b)
MBASED:::getAB(MBASED:::getMuRho(a=0.2, b=4)$mu, MBASED:::getMuRho(a=0.2, b=4)$rho)
}
\seealso{
Other bbFunctions: \code{\link{vectorizedRbetabinomAB}},
  \code{\link{vectorizedRbetabinomMR}},
  \code{\link{vectorizedRbetabinomMR}}

Other bbFunctions: \code{\link{vectorizedRbetabinomAB}},
  \code{\link{vectorizedRbetabinomMR}},
  \code{\link{vectorizedRbetabinomMR}}
}

