% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholdSCRNA.R
\name{thresholdSCRNACountMatrix}
\alias{thresholdSCRNACountMatrix}
\title{Threshold a count matrix using an adaptive threshold.}
\usage{
thresholdSCRNACountMatrix(
  data_all,
  conditions = NULL,
  cutbins = NULL,
  nbins = 10,
  bin_by = "median",
  qt = 0.975,
  min_per_bin = 50,
  absolute_min = 0,
  data_log = TRUE,
  adj = 1
)
}
\arguments{
\item{data_all}{\code{matrix} of (possibly log-transformed) counts or TPM.  Rows are genes and columns are cells.}

\item{conditions}{Bins are be determined per gene and per condition.  Typically contrasts of interest should be specified.}

\item{cutbins}{\code{vector} of cut points.}

\item{nbins}{\code{integer} number of bins when cutbins is not specified.}

\item{bin_by}{\code{character} "median", "proportion", "mean"}

\item{qt}{when \code{bin_by} is "quantile", what quantile should be used to form the bins}

\item{min_per_bin}{minimum number of genes within a bin}

\item{absolute_min}{\code{numeric} giving a hard threshold below which everything is assumed to be noise}

\item{data_log}{is \code{data_all} log+1 transformed?  If so, it will be returned on the (log+1)-scale as well.}

\item{adj}{bandwith adjustment, passed to \code{density}}
}
\value{
\code{list} of thresholded counts (on natural scale), thresholds, bins, densities estimated on each bin, and the original data
}
\description{
An adaptive threshold is calculated from the conditional mean of expression, based on 10 bins
of the genes with similar expression levels. Thresholds are chosen by estimating cutpoints in the bimodal density estimates of the
binned data.
These density estimates currently exclude the zeros due to complications with how the bandwidth is selected.
(If the bandwith is too small, then extra peaks/modes are found and everything goes haywire).
If the diagnostic plots don't reveal any bimodal bins, this is probably the reason, and you may not need to threshold since background in the data are exact zeros.
}
\examples{
data(maits,package='MAST', envir = environment())
sca <- FromMatrix(t(maits$expressionmat[,1:1000]), maits$cdat, maits$fdat[1:1000,])
tt <- thresholdSCRNACountMatrix(assay(sca))
tt <- thresholdSCRNACountMatrix(2^assay(sca)-1, data_log=FALSE)
opar <- par(no.readonly = TRUE)
on.exit(par(opar))
par(mfrow=c(4,2))
plot(tt)
}
