% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCellAssay-methods.R
\name{FromMatrix}
\alias{FromMatrix}
\title{Construct a SingleCellAssay from a matrix or array of expression}
\usage{
FromMatrix(
  exprsArray,
  cData,
  fData,
  class = "SingleCellAssay",
  check_sanity = TRUE,
  check_logged = check_sanity
)
}
\arguments{
\item{exprsArray}{matrix, or a list of matrices, or an array. Columns are cells, rows are genes.}

\item{cData}{cellData an object that can be coerced to a DataFrame, ie, data.frame, AnnotatedDataFrame.  Must have as many rows as \code{ncol(exprsArray)}}

\item{fData}{featureData an object that can be coerced to a DataFrame, ie, data.frame, AnnotatedDataFrame.  Must have as many rows as \code{nrow(exprsArray)}.}

\item{class}{desired subclass of object.  Default \code{SingleCellAssay}.}

\item{check_sanity}{(default: \code{TRUE}) Set \code{FALSE} to override sanity checks that try to ensure that the default assay is log-transformed and has at least one exact zero.  See \link{defaultAssay} for details on the "default assay" which is assumed to contain log transformed data.}

\item{check_logged}{alias for \code{check_sanity}}
}
\value{
an object of class \code{class}
}
\description{
If the gene expression measurements are already in a rectangular form,
then this function allows an easy way to construct a SingleCellAssay object while
still doing some sanity checking of inputs.
}
\examples{
ncells <- 10
ngenes <- 5
fData <- data.frame(primerid=LETTERS[1:ngenes])
cData <- data.frame(wellKey=seq_len(ncells))
mat <- matrix(rnorm(ncells*ngenes), nrow=ngenes)
sca <- FromMatrix(mat, cData, fData)
stopifnot(inherits(sca, 'SingleCellAssay'))
stopifnot(inherits(sca, 'SummarizedExperiment'))
##If there are mandatory keywords expected by a class, you'll have to manually set them yourself
cData$ncells <- 1
fd <- FromMatrix(mat, cData, fData)
stopifnot(inherits(fd, 'SingleCellAssay'))
}
\seealso{
defaultAssay
}
