% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCellAssay-methods.R
\name{FromFlatDF}
\alias{FromFlatDF}
\alias{SingleCellAssay}
\alias{FluidigmAssay}
\title{Construct a SingleCellAssay (or derived subclass) from a `flat` (melted) data.frame/data.table}
\usage{
FromFlatDF(
  dataframe,
  idvars,
  primerid,
  measurement,
  id = numeric(0),
  cellvars = NULL,
  featurevars = NULL,
  phenovars = NULL,
  class = "SingleCellAssay",
  check_sanity = TRUE,
  ...
)
}
\arguments{
\item{dataframe}{A 'flattened' \code{data.frame} or \code{data.table} containing columns giving cell and feature identifiers and  a measurement column}

\item{idvars}{character vector naming columns that uniquely identify a cell}

\item{primerid}{character vector of length 1 that names the column that identifies what feature (i.e. gene) was measured}

\item{measurement}{character vector of length 1 that names the column containing the measurement}

\item{id}{An identifier (eg, experiment name) for the resulting object}

\item{cellvars}{Character vector naming columns containing additional cellular metadata}

\item{featurevars}{Character vector naming columns containing additional feature metadata}

\item{phenovars}{Character vector naming columns containing additional phenotype metadata}

\item{class}{desired subclass of object.  Default \code{SingleCellAssay}.}

\item{check_sanity}{(default: \code{TRUE}) Set \code{FALSE} to override sanity checks that try to ensure that the default assay is log-transformed and has at least one exact zero.  See \link{defaultAssay} for details on the "default assay" which is assumed to contain log transformed data.}

\item{...}{additional arguments are ignored}
}
\value{
SingleCellAssay, or derived, object
}
\description{
SingleCellAssay are a generic container for such data and are simple wrappers around SummarizedExperiment objects.
Subclasses exist that embue the container with additional attributes, eg \link{FluidigmAssay}.
}
\examples{
data(vbeta)
colnames(vbeta)
vbeta <- computeEtFromCt(vbeta)
vbeta.fa <- FromFlatDF(vbeta, idvars=c("Subject.ID", "Chip.Number", "Well"),
primerid='Gene', measurement='Et', ncells='Number.of.Cells',
geneid="Gene",cellvars=c('Number.of.Cells', 'Population'),
phenovars=c('Stim.Condition','Time'), id='vbeta all', class='FluidigmAssay')
show(vbeta.fa)
nrow(vbeta.fa)
ncol(vbeta.fa)
head(mcols(vbeta.fa)$primerid)
table(colData(vbeta.fa)$Subject.ID)
vbeta.sub <- subset(vbeta.fa, Subject.ID=='Sub01')
show(vbeta.sub)
}
