% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topSeqs.R
\name{topSeqs}
\alias{topSeqs}
\title{Top sequences}
\usage{
topSeqs(productive.seqs, top = 1)
}
\arguments{
\item{productive.seqs}{A list data frames of productive sequences generated 
by the LymphoSeq function productiveSeq.  "frequencyCount" and "aminoAcid" 
are a required columns.}

\item{top}{The number of top productive sequences in each data frame to subset 
by their frequencies.}
}
\value{
Returns a data frame of a selected number of top productive sequences 
from a list of data frames.
}
\description{
Creates a data frame of a selected number of top productive sequences 
from a list of data frames.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

top.seqs <- topSeqs(productive.seqs = productive.aa, top = 1)
}
\seealso{
\code{\link{chordDiagramVDJ}}
}
