% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloTree.R
\name{phyloTree}
\alias{phyloTree}
\title{Create phylogenetic tree}
\usage{
phyloTree(list, sample, type = "nucleotide", layout = "rectangular",
  label = TRUE)
}
\arguments{
\item{list}{A list data frames of unproductive nucleotide sequences or productive 
nucleotide sequences generated by the LymphoSeq function productiveSeq.  
vFamilyName, dFamilyName, jFamilyName, and count are required columns.}

\item{sample}{A character vector indicating the name of the sample in the productive
sequence list.}

\item{type}{A character vector indicating whether "aminoAcid" or "nucleotide" sequences
should be compared.}

\item{layout}{A character vector indicating the tree layout.  Options include 
"rectangular", "slanted", "fan", "circular", "radial" and "unrooted".}

\item{label}{A Boolean indicating if the sequencing count should be shown next to the leaves.}
}
\value{
Returns a phylogenetic tree where each leaf represents a sequence color coded by the
V, D, and J gene usage.  The number next to each leaf refers to the sequence count.  A triangle 
shaped leaf indicates the dominant sequence.  Refer to the ggtree Bioconductor package 
documentation for details on how to manipulate the tree.
}
\description{
Create a phylogenetic tree using neighbor joining tree estimation for amino acid or 
nucleotide CDR3 sequences in a list of data frames.
}
\examples{
file.path <- system.file("extdata", "IGH_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.nt <- productiveSeq(file.list = file.list, aggregate = "nucleotide")

phyloTree(list = productive.nt, sample = "IGH_MVQ92552A_BL", type = "nucleotide", 
         layout = "rectangular")

phyloTree(list = productive.nt, sample = "IGH_MVQ92552A_BL", type = "aminoAcid", 
         layout = "circular")
         
# Add scale and title to figure
library(ggtree)
library(ggplot2)
phyloTree(list = productive.nt, sample = "IGH_MVQ92552A_BL", type = "aminoAcid", 
         layout = "rectangular") +
         ggtree::theme_tree2() +
         ggplot2::theme(legend.position = "right", legend.key = element_rect(colour = "white")) +
         ggplot2::ggtitle("Title")
         
# Hide legend and leaf labels
phyloTree(list = productive.nt, sample = "IGH_MVQ92552A_BL", type = "nucleotide", 
         layout = "rectangular", label = FALSE) +
         ggplot2::theme(legend.position="none")
         
}
