% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFasta.R
\name{exportFasta}
\alias{exportFasta}
\title{Export sequences in fasta format}
\usage{
exportFasta(list, type = "nucleotide", names = c("rank", "aminoAcid",
  "count"))
}
\arguments{
\item{list}{A list of data frames consisting of antigen receptor sequences 
imported by the LymphoSeq function readImmunoSeq.}

\item{type}{A character vector indicating whether "aminoAcid" or "nucleotide" sequences
should be exported.  If "aminoAcid" is specified, then run productiveSeqs first.}

\item{names}{A character vector of one or more column names to name the sequences.
If "rank" is specified, then the rank order of the sequences by frequency is used.}
}
\value{
Exports fasta files to the working directory.
}
\description{
Export nucleotide or amino acid sequences in fasta format.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

exportFasta(list = file.list, type = "nucleotide", names = c("rank", "aminoAcid", "count"))

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

exportFasta(list = productive.aa, type = "aminoAcid", names = "frequencyCount")
}
