% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonSeqsVenn.R
\name{commonSeqsVenn}
\alias{commonSeqsVenn}
\title{Common sequences Venn diagram}
\usage{
commonSeqsVenn(samples, productive.seqs)
}
\arguments{
\item{samples}{A character vector of two or three names of samples in 
productive.seqs to compare.}

\item{productive.seqs}{A list of productive amino acid sequences generated
by the LymphoSeq function productiveSeq.}
}
\value{
Returns a a Venn diagram of the number of common sequences between
two or three samples.
}
\description{
Creates a Venn diagram comparing the number of common sequences in two or 
three samples.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

# Plot a triple Venn diagram
commonSeqsVenn(samples = c("TRB_Unsorted_0", 
   "TRB_Unsorted_32", "TRB_Unsorted_83"), 
   productive.seqs = productive.aa)

# Plot a double Venn diagram
commonSeqsVenn(samples = c("TRB_Unsorted_0", 
   "TRB_Unsorted_32"), productive.seqs = productive.aa)

# Save Venn diagram as a .png file to working directory
png(filename = "Venn diagram.png", res = 300, units = "in", height = 5, width = 5)

commonSeqsVenn(samples = c("TRB_Unsorted_0", "TRB_Unsorted_32"), 
   productive.seqs = productive.aa)

dev.off()
}
\seealso{
\code{\link{commonSeqs}}
}
