% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRegion1D.R
\name{plotRegion1D}
\alias{plotRegion1D}
\alias{plotRegion1D,LipidTrendSE-method}
\title{Plot region trends for one-dimensional lipid feature}
\usage{
plotRegion1D(object, p_cutoff = 0.05, y_scale = "identity")

\S4method{plotRegion1D}{LipidTrendSE}(object, p_cutoff = 0.05, y_scale = "identity")
}
\arguments{
\item{object}{A LipidTrendSE object generated by \code{analyzeLipidRegion()}
for one-dimensional feature analysis.}

\item{p_cutoff}{Numeric. Significance threshold for highlighting regions
based on smoothed permutation p-values. Default is \code{0.05}.}

\item{y_scale}{Character. Scale of the y-axis. Choose from \code{"identity"},
\code{"log2"}, \code{"log10"}, or \code{"sqrt"}. Default is
\code{"identity"}.}
}
\value{
If \code{split_chain=TRUE} in the analysis, the function returns a list
containing two plots:
\enumerate{
\item{even_result: A ggplot object visualizing trends for
even-chain lipids, or \code{NULL} if no such lipids exist.}
\item{odd_result: A ggplot object visualizing trends for odd-chain
lipids, or \code{NULL} if no such lipids exist.}
}
If \code{split_chain=FALSE}, the function returns a single ggplot object
visualizing the trend for all lipids combined.
}
\description{
Visualize lipid trends from one-dimensional analysis results.
The plot highlights regions of significant group differences based on the
smoothed permutation test. Blue and red ribbons mark where the trend
significantly decreases or increases, respectively, in the case group
compared to the control group. Each point represents the mean abundance
within each group (case vs. control) for a specific lipid feature.
This visualization helps identify not only abundance differences but also
the specific lipid feature regions where trends diverge between groups.
}
\examples{
data("lipid_se_CL")
res_se <- analyzeLipidRegion(
    lipid_se=lipid_se_CL, ref_group="sgCtrl", split_chain=FALSE,
    chain_col=NULL, radius=2, own_contri=0.5, test="t.test",
    abund_weight=TRUE, permute_time=100)
plot <- plotRegion1D(res_se, p_cutoff=0.05, y_scale='identity')
}
\seealso{
\code{\link{analyzeLipidRegion}} for generating the input LipidTrendSE object
}
