% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Linnorm.SGenes.R
\name{Linnorm.SGenes}
\alias{Linnorm.SGenes}
\title{Linnorm model stable gene selection tool.}
\usage{
Linnorm.SGenes(
  datamatrix,
  RowSamples = FALSE,
  showinfo = FALSE,
  minNonZeroPortion = 0.75,
  F_p = 0.3173,
  F_LC_Genes = "Auto",
  F_HC_Genes = 0.01,
  max_F_LC = 0.75
)
}
\arguments{
\item{datamatrix}{The matrix or data frame that contains your dataset. Raw Counts, CPM, RPKM, FPKM or TPM are supported. Undefined values such as NA are not supported. It is not compatible with log transformed datasets.}

\item{RowSamples}{Logical. In the datamatrix, if each row is a sample and each column is a feature, set this to TRUE so that you don't need to transpose it. Linnorm works slightly faster with this argument set to TRUE, but it should be negligable for smaller datasets. Defaults to FALSE.}

\item{showinfo}{Logical. Show algorithm running information. Defaults to FALSE.}

\item{minNonZeroPortion}{Double >=0, <= 1. Minimum non-Zero Portion Threshold. Genes not satisfying this threshold will be removed. For exmaple, if set to 0.75, genes without at least 75 percent of the samples being non-zero will be removed. Defaults to 0.75.}

\item{F_p}{Double >=0, <= 1. Filter genes with standard deviation and skewness less than this p value. Defaults to 0.3173.}

\item{F_LC_Genes}{Double >= 0.01, <= 0.95 or Character "Auto". Filter this portion of the lowest expressing genes. It can be determined automatically by setting to "Auto". Defaults to "Auto".}

\item{F_HC_Genes}{Double >=0, <= 1. Filter this portion of the highest expressing genes. Defaults to 0.01.}

\item{max_F_LC}{Double >=0, <= 0.95. When F_LC is set to auto, this is the maximum threshold that Linnorm would assign. Defaults to 0.75.}
}
\value{
This function returns a data matrix that contains stable genes only.
}
\description{
For datasets without spike-ins and for users who do not wish to rely on spike-ins, we provide this model stable gene selection tool.
}
\details{
This function selects stable genes from the dataset using the Linnorm's algorithm.
}
\examples{
#Obtain example matrix:
data(Islam2011)
#Transformation:
StableGenes <- Linnorm.SGenes(Islam2011)
}
\keyword{CPM}
\keyword{Count}
\keyword{Expression}
\keyword{FPKM}
\keyword{Filter}
\keyword{Linnorm}
\keyword{RNA-seq}
\keyword{RPKM}
\keyword{Raw}
\keyword{Stable}
\keyword{TPM}
