% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Linnorm.Cor.R
\name{Linnorm.Cor}
\alias{Linnorm.Cor}
\title{Linnorm-gene correlation network analysis.}
\usage{
Linnorm.Cor(
  datamatrix,
  RowSamples = FALSE,
  input = "Raw",
  method = "pearson",
  MZP = 0.5,
  sig.q = 0.05,
  plotNetwork = TRUE,
  plotNumPairs = 5000,
  plotdegree = 0,
  plotname = "networkplot",
  plotformat = "png",
  plotVertexSize = 1,
  plotFontSize = 1,
  plot.Pos.cor.col = "red",
  plot.Neg.cor.col = "green",
  vertex.col = "cluster",
  plotlayout = "kk",
  clusterMethod = "cluster_edge_betweenness",
  ...
)
}
\arguments{
\item{datamatrix}{The matrix or data frame that contains your dataset. Raw Counts, CPM, RPKM, FPKM, TPM or Linnorm transformed data are supported. Undefined values such as NA are not supported.}

\item{RowSamples}{Logical. In the datamatrix, if each row is a sample and each column is a feature, set this to TRUE so that you don't need to transpose it. Linnorm works slightly faster with this argument set to TRUE, but it should be negligable for smaller datasets. Defaults to FALSE.}

\item{input}{Character. "Raw" or "Linnorm". In case you have already transformed your dataset with Linnorm, set input into "Linnorm" so that you can put the Linnorm transformed dataset into the "datamatrix" argument. Defaults to "Raw".}

\item{method}{Character. "pearson", "kendall" or "spearman". Method for the calculation of correlation coefficients. Defaults to "pearson".}

\item{MZP}{Double >=0, <= 1. Minimum non-Zero Portion Threshold for this function. Genes not satisfying this threshold will be removed for correlation calculation. For exmaple, if set to 0.3, genes without at least 30 percent of the samples being non-zero will be considered for this study. Defaults to 0.5.}

\item{sig.q}{Double >=0, <= 1. Only gene pairs with q values less than this threshold will be included in the "Results" data frame. Defaults to 0.05.}

\item{plotNetwork}{Logical. Should the program output the network plot to a file? An "igraph" object will be included in the output regardless. Defaults to TRUE.}

\item{plotNumPairs}{Integer >= 50. Number of gene pairs to be used in the network plot. Defaults to 5000.}

\item{plotdegree}{Integer >= 0. In the network plot, genes (vertices) without at least this number of degree will be removed. Defaults to 0.}

\item{plotname}{Character. Name of the network plot. File extension will be appended to it. Defaults to "networkplot".}

\item{plotformat}{Character. "pdf" or "png". Network plot output format. Defaults to "png".}

\item{plotVertexSize}{Double >0. Controls vertex Size in the network plot. Defaults to 1.}

\item{plotFontSize}{Double >0. Controls font Size in the network plot. Defaults to 1.}

\item{plot.Pos.cor.col}{Character. Color of the edges of positively correlated gene pairs. Defaults to "red".}

\item{plot.Neg.cor.col}{Character. Color of the edges of negatively correlated gene pairs. Defaults to "green".}

\item{vertex.col}{Character. "cluster" or a color. This controls the color of the vertices. Defaults to "cluster".}

\item{plotlayout}{Character. "kk" or "fr". "kk" uses Kamada-Kawai algorithm in igraph to assign vertex and edges. It scales edge length with correlation strength. However, it can cause overlaps between vertices. "fr" uses Fruchterman-Reingold algorithm in igraph to assign vertex and edges. It prevents overlatps between vertices better than "kk", but edge lengths are not scaled to correlation strength. Defaults to "kk".}

\item{clusterMethod}{Character. "cluster_edge_betweenness", "cluster_fast_greedy", "cluster_infomap", "cluster_label_prop", "cluster_leading_eigen", "cluster_louvain", "cluster_optimal", "cluster_spinglass" or "cluster_walktrap". These are clustering functions from the igraph package. Defaults to "cluster_edge_betweenness".}

\item{...}{arguments that will be passed into Linnorm's transformation function.}
}
\value{
This function will output a list with the following objects:
\itemize{
 \item{Results:}{ A data frame containing the results of the analysis, showing only the significant results determined by "sig.q" (see below).}
 \item{Cor.Matrix:}{ The resulting correlation matrix between each gene. }
 \item{q.Matrix:}{ A matrix of q values of each of the correlation coefficient from Cor.Matrix. }
 \item{Cluster:}{ A data frame that shows which gene belongs to which cluster.}
 \item{igraph:}{ The igraph object for users who want to draw the network plot manually. }
 \item{Linnorm:}{ Linnorm transformed data matrix.}
}

The "Results" data frame has the following columns:
\itemize{
 \item{Gene1:}{ Name of gene 1.}
 \item{Gene2:}{ Name of gene 2.}
 \item{Cor:}{ Correlation coefficient between the two genes.}
 \item{p.value:}{ p value of the correlation coefficient.}
 \item{q.value:}{ q value of the correlation coefficient.}
}
}
\description{
This function first performs Linnorm transformation on the dataset. Then, it will perform correlation network analysis on the dataset.
}
\details{
This function performed gene correlated study in the dataset by using Linnorm transformation
}
\examples{
data(Islam2011)
#Analysis on Islam2011 embryonic stem cells
results <- Linnorm.Cor(Islam2011[,1:48], plotNetwork=FALSE)
}
\keyword{CPM}
\keyword{Count}
\keyword{Expression}
\keyword{FPKM}
\keyword{Linnorm}
\keyword{Parametric}
\keyword{RNA-seq}
\keyword{RPKM}
\keyword{Raw}
\keyword{TPM}
\keyword{coefficient}
\keyword{correlation}
\keyword{kendall}
\keyword{normalization}
\keyword{pearson}
\keyword{spearman}
\keyword{transformation}
