% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitFileIntoCollection.R
\name{splitFileIntoCollection}
\alias{splitFileIntoCollection}
\title{This function will take a single large bed file that is annotated
with a column grouping different sets of similar regions,
and split it into separate files for use with the LOLA collection format.}
\usage{
splitFileIntoCollection(
  filename,
  splitCol,
  collectionFolder = NULL,
  filenamePrepend = ""
)
}
\arguments{
\item{filename}{the file to split}

\item{splitCol}{factor column that groups the lines in the file by set. It 
should be an integer.}

\item{collectionFolder}{name of folder to place the new split files.}

\item{filenamePrepend}{string to prepend to the filenames. Defaults to blank.}
}
\value{
No return value.
}
\description{
This function will take a single large bed file that is annotated
with a column grouping different sets of similar regions,
and split it into separate files for use with the LOLA collection format.
}
\examples{
combFile = system.file("extdata", "examples/combined_regions.bed", package="LOLA")
splitFileIntoCollection(combFile, 4)
}
