% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowseqReport.R
\name{knowseqReport}
\alias{knowseqReport}
\title{knowseqReport creates a report for a given set of genes which their label.}
\usage{
knowseqReport(
  data,
  labels,
  MLTest = FALSE,
  testData = "",
  testLabels = "",
  outdir = "knowSeq-report",
  qualityAnalysis = TRUE,
  batchEffectTreatment = TRUE,
  geneOntology = TRUE,
  getPathways = TRUE,
  getDiseases = TRUE,
  lfc = 2,
  pvalue = 0.01,
  cov = 2,
  featureSelectionMode = "nofs",
  disease = "",
  subdiseases = c(""),
  maxGenes = 150,
  clasifAlgs = c("knn", "rf", "svm"),
  metrics = c("accuracy", "specificity", "sensitivity")
)
}
\arguments{
\item{data}{A matrix that contains the gene expression.}

\item{labels}{A vector or factor that contains the labels for each of the samples in the data object.}

\item{MLTest}{This parameter enables the classification process for a test dataset.}

\item{testData}{A matrix that contains the unseen samples for the test process.}

\item{testLabels}{A vector or factor that contains the labels for the unseen samples for the test process.}

\item{outdir}{The output directory to store the report.}

\item{qualityAnalysis}{A logical parameter that indicates if the user wants to perform the quality anaylisis or not.}

\item{batchEffectTreatment}{A logical parameter that indicates if the user wants to perform the batch effect treatment or not.}

\item{geneOntology}{A logical parameter that indicates if the user wants to show genes ontologies or not.}

\item{getPathways}{A logical parameter that indicates if the user wants to show genes pathways or not.}

\item{getDiseases}{A logical parameter that indicates if the user wants to show genes related diseases or not.}

\item{lfc}{The value of the LFC which determines the DEGs. If one or more genes have a LFC greater or equal to the selected LFC, they would be considered as DEGs.}

\item{pvalue}{The value of the p-value which determines the DEGs. If one or more genes have a p-value lower or equal to the selected p-value, they would be considered as DEGs.}

\item{cov}{This value only works when there are more than two classes in the labels. This parameter stablishs a minimum number of pair of classes combination in which exists differential expression to consider a genes as expressed genes.}

\item{featureSelectionMode}{String that indicates which feature selection algorithm is going to be used. Possible values are: mrmr, rf or da. By default, no feature selection algorithm will be applied.}

\item{disease}{String that indicates from which disease wants the user wants to know if selected genes are related to. Found evidences will be shown for each subdiseases. Default empty, this means that all related diseases, and found evidences, will be shown.}

\item{subdiseases}{String that indicates the name of a particular subtype from disease, which  the  user to know if selected genes are related to. Found evidences will be shown. Default empty, this means that there are not subtypes of disease to look for, all found evidences for disease will be shown.}

\item{maxGenes}{Integer that indicates the maximun number of genes which information will be shown and that will be used to train models.}

\item{clasifAlgs}{A vector with including algorithms names that will be used in training cv.}

\item{metrics}{A list with metrics that the user wants to be shown in machine learning process. Metrics could be accuracy, specificity and/or sensitivity.}
}
\value{
Nothing to return.
}
\description{
knowseqReport creates a report for a given set of genes which their label. This provide an html file with all the information that can be obtained for a certain set of genes (as GO, pathway visualization, associated diseases) and their labels (machine learning process).
}
\examples{
dir <- system.file("extdata", package="KnowSeq")
load(paste(dir,"/expressionExample.RData",sep = ""))
\dontrun{knowseqReport(expressionMatrix,labels,'knowSeq-report',clasifAlgs=c('rf'),disease='lung-cancer',maxGenes = 9)}
\dontrun{knowseqReport(expressionMatrix,labels,'knowSeq-report',clasifAlgs=c('rf'),disease='lung-cancer',subdiseases=c('squamous cell lung carcinoma','lung adenocarcinoma'),maxGenes = 9)}
}
