% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEGsExtraction.R
\name{DEGsExtraction}
\alias{DEGsExtraction}
\title{DEGsExtraction performs the analysis to extract the Differentially Expressed Genes (DEGs) among the classes to compare.}
\usage{
DEGsExtraction(
  expressionMatrix,
  labels,
  pvalue = 0.05,
  lfc = 1,
  cov = 1,
  nmax = 1,
  multiDegsMethod = "cov",
  number = Inf,
  CV = FALSE,
  numFolds = 5
)
}
\arguments{
\item{expressionMatrix}{The expressionMatrix parameter is an expression matrix or data.frame that contains the genes in the rows and the samples in the columns.}

\item{labels}{A vector or factors that contains the labels for each of the samples in the expressionMatrix parameter.}

\item{pvalue}{The value of the p-value which determines the DEGs. If one or more genes have a p-value lower or equal to the selected p-value, they would be considered as DEGs.}

\item{lfc}{The value of the LFC which determines the DEGs. If one or more genes have a LFC greater or equal to the selected LFC, they would be considered as DEGs.}

\item{cov}{This value only works when there are more than two classes in the labels. This parameter establishes a minimum number of pair of classes combination in which exists differential expression to consider a genes as expressed genes.}

\item{nmax}{This value only works when there are more than two classes in the labels. NMAX indicates the maximum number of DEGs selected for each class pair comparison.}

\item{multiDegsMethod}{Select the multiclass extraction method for the process: cov or nmax}

\item{number}{The maximum number of desired genes as output of limma. As default, the function returns all the extracted DEGs with the selected parameters.}

\item{CV}{A boolean value that has to be setted to TRUE if the user would to run a Cross-Validation DEGs extraction process.}

\item{numFolds}{This parameter indicates the number of folds for the Cross-Validation process.}
}
\value{
A list that contains two objects. The table with statistics of the different DEGs and a reduced expression matrix which contains the DEGs and the samples.
}
\description{
The function performs the analysis to extract the Differentially Expressed Genes (DEGs) among the classes to compare. The number of final DEGs can change depending on the p-value and the LFC indicated by parameters of the function. Furthermore, the function detects if the number of classes are greater than 2 to perform a multiclass DEGs analysis.
}
\examples{
dir <- system.file("extdata", package="KnowSeq")
load(paste(dir,"/expressionExample.RData",sep = ""))

expressionMatrix <- calculateGeneExpressionValues(countsMatrix,myAnnotation, genesNames = TRUE)

DEGsInformation <- DEGsExtraction(expressionMatrix, labels, lfc = 2.0,
pvalue = 0.01, number = Inf)

topTable <- DEGsInformation$Table

DEGsMatrix <- DEGsInformation$DEGsMatrix
}
