% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KBoost.R
\name{kboost}
\alias{kboost}
\title{A function to run KBoost.}
\usage{
kboost(X, TFs, g, v, prior_weights, ite)
}
\arguments{
\item{X}{an NxG matrix with the expression values of G genes and N obvs..}

\item{TFs}{a Kx1 numeric matrix with integers of columns of X that are TFs.}

\item{g}{a positive no., width parameter for RBF kernel. (default g = 40)}

\item{v}{a no. between 0 and 1 with the shrinkage parameter. (default v =0.1)}

\item{prior_weights}{it can be a scalar or GxK. (default 0.5)}

\item{ite}{an integer for the maximum number of iterations (default 3)}
}
\value{
a list with the results for kboost, with fields:
GRN a matrix with the posterior edge probability after network refinement.
GRN_UP a matrix with the posterior edges before refinement.
model a matrix with logical values for the TFs selected for each gene.
g the width parameter for the RBF kernel.
v the shrinkage parameter.
prior the prior of each model.
TFs a matrix with integers of each gene that is a TF.
prior_weights the prior_weights with which KBoost was run.
run_time a sacalar with the running time.
}
\description{
A function to run KBoost.
}
\examples{
data(D4_multi_1)
Net <- kboost(D4_multi_1)

}
