% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KPC.R
\name{KPC}
\alias{KPC}
\title{Function to calculate the principal components of a kernel.}
\usage{
KPC(K, thr)
}
\arguments{
\item{K}{an NxN numeric matrix with the Kernel matrix.}

\item{thr}{a positive scalar which is a threshold to discard eigen-vectors based on eigen-values.}
}
\value{
the kernel principal components
}
\description{
Function to calculate the principal components of a kernel.
}
\examples{
x = rnorm(100,0,1)
k = RBF_K(x,1)
k_ = kernel_normal(k)
kpca = KPC(k,1e-8)
}
