% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genes_Stat.r
\name{genes_Stat}
\alias{genes_Stat}
\title{Extracting miRNAs that target a query gene.}
\usage{
genes_Stat(
  gene,
  geneIDType = c("GeneSymbol", "FBGN", "CGID"),
  method = c("Pearson", "Distance", "Both", "BothIntersect"),
  Platform = c("Affy1", "Affy2"),
  Text = FALSE,
  outpath = tempdir()
)
}
\arguments{
\item{gene}{character. gene Identifier.}

\item{geneIDType}{character. GeneIDtype choices are 'GeneSymbol', 
'FBGN', 'CGID'}

\item{method}{character. Choices are 'Pearson','Distance','Both' and
'BothIntersected'}

\item{Platform}{character. Choices are
'Affy1','Affy2'.}

\item{Text}{logical . To choose between storing the data as text file.
Default is FALSE.}

\item{outpath}{character. The path where the data is stored if TEXT=TRUE.
Default is}
}
\value{
Outputs the miRNA information, Target Prediction Score, miRNA 
        miRNA function and Target Database that predicts the interaction in
        a dataframe.
        Depending upon the ouput choice data is stored in the
        path specified. Default option prints output to the console.
}
\description{
Extracting miRNAs that target a query gene.
}
\examples{
gene="Syb"
genes_Stat(gene,geneIDType="GeneSymbol",method=c("Pearson"),
           Platform=c("Affy1"),Text=FALSE)
}
