#' about UI Function
#'
#' @description A shiny Module.
#'
#' @param id,input,output,session Internal parameters for {shiny}.
#'
#' @noRd 
#'
#' @importFrom shiny NS tagList 
mod_about_ui <- function(id){
  ns <- NS(id)
  tagList(
    fluidRow(
      column(width = 6,
             img(src = "www/About_shiny_lowres.png", width = "100%")
      ),
      column(width = 6,
             h2("Welcome to InterCellar!"),
             h4("Analyze and explore cell-cell communication based on single-cell RNAseq data."),
             p("First time here? Have a look at the user-guide below!"),
             tabBox(width = 12,
                    title = "1. Data Upload",
                    tabPanel("Upload", p(
                      "The first step of the workflow requires the upload
                             of pre-computed results generated by an external 
                             tool capable of predicting cell-cell communication,
                             based on ligand-receptor interactions. 
                             InterCellar supports both published tools such as ",
                      tags$a(href= "https://www.cellphonedb.org/", "CellPhoneDBv2"),
                      " or ", tags$a(href="https://github.com/sqjin/CellChat",
                                     "CellChat"),
                      " and custom results output of",  em("ad hoc"), "methods.
                             Having chosen your input method, simply select the 
                             folder (or file) containing your results from a local drive.
                      Multiple cell-cell interactions (CCI) datasets can be uploaded and parallely analyzed.
                      Moreover, a comparison between different conditions (e.g., treated VS untreated) 
                      can be performed in step 3. of the workflow."
                             
                             
                    )
                             ),
                    tabPanel("Table View", p(
                      "InterCellar pre-processed data will be shown in Table View."),
                      p("The pre-processing step consists of:"),
                      tags$ul(
                        tags$li(p("Mapping interaction pairs to the 
                                  corresponding genes (hgnc symbols), when necessary")),
                        tags$li(p("Annotating genes to their molecular function: 
                                  L (ligand) or R (receptor)")),
                        tags$li(p("Re-ordering the interaction pairs listed as R-L to L-R"))
                      )
                        
                      
                    )
                    
             ),
             tabBox(width = 12,
                    title = "2. Data exploration: Universes",
                    height = "350px",
                    tabPanel("Cluster-verse", 
                             div(style = 'overflow-y:scroll;height:250px;',
                               p(
                      "Focus of this universe are clusters of cells 
                      participating in the communication. The filtering options 
                      allow to subset the dataset by: "),
                      tags$ul(
                        tags$li("excluding entire clusters from the data. 
                        All interactions related to the removed
                                clusters will be excluded from 
                                further steps of the analysis;"),
                        tags$li("selecting int-pairs based on a minimum interaction score;"),
                        tags$li("(when available) changing the p-value threshold 
                                for significant interactions (default to 0.05).")
                      ),
                      p("The effect of these 
                      filtering steps will be shown in the 
                      box with the number of total interactions."),
                      tagList(shiny::icon("exclamation-triangle"), "Warning: these filters have 
                              global influence on the analysis, since they subset the input data."),
                      br(),
                      p("Three panels are part of the cluster-verse: "),
                      tags$ul(
                        tags$li(p(tags$b("Network: "), "shows the overall cellular 
                        communication. Nodes represent different clusters while 
                                  edges show the number of interactions (total or weighted by the interaction score.")),
                        tags$li(p(tags$b("Barplot: "), "two different barplots 
                        representing: (1) the total 
                        number of interactions per cluster, divided in paracrine 
                                  and autocrine interactions; and (2) the 
                                  relative number of interactions for a certain cell type.")),
                        tags$li(p(tags$b("Table: "), "is used to restrict the  
                        exploration to a specific focus, by subsetting the data 
                        to one cluster of interest, called ", tags$em("viewpoint"), " 
                        and one ", tags$em("flow"), " of communication among: 
                                  Directed, outgoing interactions (L-R); 
                                  Directed, incoming interactions (R-L);
                                  Undirected interactions (L-L and R-R).")
                        )
                      )
                             )

                    ),
                    tabPanel("Gene-verse",
                             div(style = 'overflow-y:scroll;height:250px;',
                                 p("Different filtering options are available
                                 depending on the uploaded input data and allow the user 
                                   to exclude int-pairs from further analysis."),
                                 tagList(shiny::icon("exclamation-triangle"), "Warning: these filters have 
                              global influence on the analysis, since they subset the input data."),
                                 br(),
                             p("Three panels are available here:"),
                             tags$ul(
                               tags$li(p(tags$b("Table:"), "shows all unique 
                                         int-pairs enriched in the data, 
                                         regardless of the clusters in which 
                                         these are found. InterCellar provides, 
                                         for each gene, links to Ensembl and Uniprot online
                                         databases to facilitate the investigation of
                                         unfamiliar genes.")),
                               tags$li(p(tags$b("Dotplot:"), "upon selection of 
                                         one or multiple int-pairs from the 
                                         previous table, a dotplot is generated.
                                          The analyst can decide to exclude 
                                         unwanted clusters from the 
                                         visualization as well as choose 
                                         different colors for high and low 
                                         int-pair score.")),
                               tags$li(p(tags$b("Network:"), "upon selection of
                                         one or multiple int-pairs from the Table, 
                                         a network of the corresponding interactions 
                                         is generated." 
                                         ))
                               
                             )

                             )      
                    ),
                    tabPanel("Function-verse",
                             div(style = 'overflow-y:scroll;height:250px;',
                                 p("Functional annotation is a required step 
                                   before proceeding to InterCellar's
                                   data-driven analyses. To this end, InterCellar offers 
                                   multiple sources of functional annotations 
                                   in terms of ",
                                   tags$a(href="http://geneontology.org", "Gene Ontology"),
                                   " (queried from ", 
                                   tags$a(href="http://www.ensembl.org", "Ensembl"),
                                   ", via the package ",
                                   tags$a(href="https://bioconductor.org/packages/biomaRt/",
                                          "biomaRt"),
                                   ") and pre-downloaded Pathway databases (from the package ",
                                   tags$a(href="https://bioconductor.org/packages/graphite/",
                                          "graphite"),
                                   "). After selection of suitable sources, the 
                                   annotation can be performed and a ",
                                   tags$b("Table"), " showing all functional 
                                   terms annotated to each int-pair is displayed."),
                                 p("Note: a functional term is annotated to an 
                                     int-pair only when the functional term is 
                                     enriched in both genes (or gene complexes), partners of the 
                                     interaction."),
                                 p("The ", tags$b("Barplot"), " panel summarizes 
                                   the number of functional terms annotated 
                                   for each source."),
                                 p("In the following panel, ",
                                 tags$b("Ranking"), ", functional terms are 
                                 listed individually, along with information on ",
                                 tags$em("occurrence"), " (i.e., how many 
                                 int-pairs have been annotated to each term)"),
                                 p("By selecting one row of the ",
                                   tags$b("Ranking"), " table, 
                                   the term of interest can be explored in the ",
                                   tags$b("Sunburst"), " plot. This visualization 
                                   allows to connect functions to int-pairs 
                                   and clusters. On the left side of the panel, 
                                   a table lists all int-pairs annotated to the 
                                   term. On the right side, the sunburst plot 
                                   is composed as follows:"),
                                 tags$ul(
                                   tags$li("the selected functional term is 
                                           shown in the inner ring of the plot;"),
                                   tags$li("the inner ring shows all 'first 
                                           partner' clusters, enriched by the 
                                           relevant int-pairs. Specifically, 
                                           clusters on the inner ring express 
                                           the first gene of each int-pair;"),
                                   tags$li("the outer ring displays all 
                                           'second partner' clusters, expressing 
                                           the second gene of each int-pair;"),
                                   tags$li("the width of each section represents 
                                           the fraction of int-pairs found in 
                                           that section (also shown when 
                                           hovering on the inner ring sections);"),
                                   tags$li("hovering on outer ring sections 
                                           will show the individual int-pairs 
                                           enriched in the cluster pairs.")
                                 )
                               
                             )
                    )
                    
             ),
             tabBox(width = 12,
                    title = "3. Data-driven Analysis",
                    tabPanel("Int-Pair Modules", 
                             div(style = 'overflow-y:scroll;height:250px;',
                                 p("This analysis 
                                   allows the definition of ",
                                   tags$b("Int-Pair Modules"), ", i.e. groups of 
                                   int-pairs that share a similar functional 
                                   profile. To this end, the choice of a ",
                                   tags$em("viewpoint"), " cluster and 
                                  a communication ", tags$em("flow"), " is required.
                                   InterCellar will subset the input data 
                                   accordingly. This analysis can be repeated 
                                   for each viewpoint and flow of interest."
                                 ),
                                 p("To define the number of int-pair modules in 
                                   the data subset, four visualizations are 
                                   provided. The optimal number of modules is 
                                   calculated by InterCellar using (1) the 
                                   elbow method on the total within-clusters sum of 
                                   squares (which should be minimized) and (2) 
                                   the average silhouette width (which should be maximized). 
                                   Both methods are standard practice in cluster 
                                   analysis and are supposed to help
                                   the choice the optimal number of modules. 
                                   However, the user is free to choose the best 
                                   number of modules depending on each case. In general, 
                                   high (low) number of groups is reflected in high (low) 
                                   specificity of a 
                                   module. For this purpose, 
                                   two visualization offer yet another way to 
                                   investigate the optimal number of modules. A ",
                                   tags$b("dendrogram"), " of int-pairs shows 
                                   the result of a hierarchical clustering 
                                   obtained on the first two components of the ",
                                   tags$b("UMAP"), " underneath. Each point of 
                                   the UMAP represents one int-pair 
                                   (shown by hovering) and color-coding is 
                                   consistent for both UMAP and dendrogram, 
                                   showing the number of modules chosen. 
                                   Moreover, dendrogram and UMAP are initialized 
                                   with the optimal number of modules result of 
                                   the elbow method."),
                                 p("Once the int-pair modules have been defined, 
                                   InterCellar offers the possibility to visualize 
                                   the int-pairs belonging to each module and 
                                   the respective clusters in a ",
                                   tags$b("Circle plot"), ". Directed interactions 
                                   are represented here by arrows originating 
                                   from ligands (double segment) towards 
                                   receptors (single segment). The ",
                                   tags$b("Table"), " panel summarizes the same 
                                   info in a tabular format."),
                                 p("Last step of the int-pair modules analysis 
                                   concerns functional terms. Upon 
                                   selection of one int-pair module, InterCellar 
                                   performs a permutation test to calculate 
                                   empirical p-values assessing the significance 
                                   of functional terms annotated to int-pairs of 
                                   the selected module. A ",
                                   tags$b("Table"), " displays functional terms 
                                   that are found significant (p-value <= 0.05 
                                   by default) for the chosen int-pair module.")
                             )
                             
                             ),
                    tabPanel("Multiple Conditions", 
                             div(style = 'overflow-y:scroll;height:250px;',
                                 p("The final step of InterCellar's analysis 
                                   allows the comparison of cell-cell communication
                                   from different conditions (up to 3). The user can 
                                   choose which conditions to compare (we recommend having the same 
                                   -or very similar- composition in terms of cell clusters). The analysis 
                                   is then structured as follow:"),
                                 tags$ul(
                                   tags$li(p(tags$b("Cluster-based: "), 
                                   "the comparison focuses on the number of interactions per cluster.
                                   Panel ", tags$b("Back-to-Back Barplot"), " considers the first two conditions and plots
                                   a barplot comparing the total number of interactions per cluster. Panel ", 
                                   tags$b("Radar Plot"), " compares the relative numbers of interaction from a certain
                                   viewpoint cell cluster, for two or three conditions.")),
                                   tags$li(p(tags$b("Gene-based: "), 
                                             "InterCellar computes ", tags$em("int-pair/cluster-pair couplets"), "
                                              that are unique to each condition and displays them in the ", tags$b("Table"), ". 
                                             Upon selection of one or multiple unique couplets, a ", tags$b("Dot Plot"), " is generated, 
                                             showing the occurrence of each couplet in the respective condition. A ", tags$b("Pie Chart"), 
                                             " summarizes the contribution of the selected couplets to each condition.")),
                                   tags$li(p(tags$b("Function-based: "), 
                                             "here only int-pairs that are uniquely found in each condition are considered. These are shown
                                             in ", tags$b("Table-UniqueIntPairs"), " along with the condition and cluster-pairs.
                                             Based on the functional annotation performed in the ", tags$em("function-verse"), " InterCellar
                                             implements a permutation test to calculate an empirical p-value of significance for the 
                                             functional terms that were annotated to these unique int-pairs. ", tags$b("Table-FuncTerms"), 
                                             " shows all functional terms that are significantly enriched by int-pairs unique to each condition.
                                             Finally, by selecting a term of interest, the user can visualize it in a ", 
                                             tags$b("Sunburst Plot"), "."))

                                 )
                             )
                    )
                    
             )
             
      )
      
    
    )
 
  )
}
    
#' about Server Functions
#'
#' @noRd 
#' @importFrom shiny renderImage
mod_about_server <- function(id){
  moduleServer( id, function(input, output, session){
    ns <- session$ns
    
    # output$workflow_img <- renderImage({
    #   list(src = "www/About_shiny.png",
    #        contentType = "image/png",
    #        width = 400,
    #        height = 500,
    #        alt = "InterCellar workflow")
    # }, deleteFile = FALSE)
  })
}
    
