\name{attributes}
\alias{attributes}
\alias{getAnnotation}
\alias{scaledRetention}

\title{
 Extracting values of useful attributes of SummarizedExperiment objects
}
\description{
Several functions are provided that can extract various attribnutes from an 
object of class \code{SummarizedExperiment} generated by IntEREst functions, 
e.g. \code{interest()}, \code{interest}, and \code{readInterestResults}. It is 
possible to extract sample annotations using \code{getAnnotation} function. 
One can also extract the scaled retention levels of the introns/exons using 
\code{scaledRetention()} function. Notes that \code{colData} and \code{rowData} 
methods of \code{SummarizedExperiment} class can also be used to extract row 
and column data.
}
\usage{
getAnnotation(x)
scaledRetention(x)
}
\arguments{
\item{x}{ 
	Object of type \code{SummarizedExperiment}.
}
}
\value{
Various data types (data.frame/vector) dependent on the function used. See the 
"Description" for more information.
}
\seealso{
	\code{\link[SummarizedExperiment]{SummarizedExperiment-class}}
	\code{\link{addAnnotation}}
	\code{\link{counts-method}}
	\code{\link{plot-method}}
}

\author{Ali Oghabian}

\examples{

# Retrieve the sample annotations from mdsChr22Obj
getAnnotation(mdsChr22Obj)
# Retrieving the scaled retention levels from mdsChr22Obj
head(scaledRetention(mdsChr22Obj))

#for row and column data SummarizedExperiment methods can be used
head(rowData(mdsChr22Obj))
colData(mdsChr22Obj)

}

