% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00.get_GCandMappability.R
\name{gcContents}
\alias{gcContents}
\title{helper function to calculate chromosome/scaffold level GC content}
\usage{
gcContents(genome, seqname, nonATCGExclude = TRUE)
}
\arguments{
\item{genome}{an object of \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}}

\item{seqname}{a character(1) vector, the chromosome/scaffold's name}

\item{nonATCGExclude}{a logical(1) vector, whether nucleotides other than A,
T, C, and G should be excluded when GC content is calculated}
}
\value{
a numeric(1) vector, containing the chromosome/scaffold -specific GC
content in the range of 0 to 1
}
\description{
helper function to calculate chromosome/scaffold level GC content
}
\examples{
\dontrun{
library(BSgenome.Mmusculus.UCSC.mm10)
genome <- BSgenome.Mmusculus.UCSC.mm10
InPAS:::gcContents(genome, "chr1")
}

}
\author{
Haibo Liu
}
\keyword{internal}
