% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00.get_GCandMappability.R
\name{gcComp}
\alias{gcComp}
\title{Calculate weights for GC composition}
\usage{
gcComp(genome, seqnames, window = 50, future.chunk.size = NULL)
}
\arguments{
\item{genome}{An object of \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}}

\item{seqnames}{a character(n) vector, the chromosome/scaffolds' names
in the same forms of seqnames in the BSgenome}

\item{window}{size of a sliding window, which optimally is set to the read
length}

\item{future.chunk.size}{The average number of elements per future
("chunk"). If Inf, then all elements are processed in a single future.
If NULL, then argument future.scheduling = 1 is used by default. Users can
set future.chunk.size = total number of elements/number of cores set for
the backend. See the future.apply package for details.}
}
\value{
A list of numeric vectors containing the weight (scaffold-level GC\\%
/ GC\\% per sliding window) for GC composition-based correction for each
chromosome/scaffold.
}
\description{
Calculate read weights for GC composition-based coverage correction
}
\examples{
\dontrun{
library(BSgenome.Mmusculus.UCSC.mm10)
genome <- BSgenome.Mmusculus.UCSC.mm10
InPAS:::gcComp(genome, "chr1")
}

}
\references{
Cheung et al. Systematic bias in high-throughput sequencing data
and its correction by BEADS. Nucleic Acids Res. 2011 Aug;39(15):e103.
}
\author{
Jianhong Ou, Haibo Liu
}
\keyword{internal}
