% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{import_ISA_settings}
\alias{import_ISA_settings}
\title{Import a dynamic vars settings profile.}
\usage{
import_ISA_settings(path)
}
\arguments{
\item{path}{The path to the json file on disk}
}
\value{
\code{NULL}
}
\description{
The function allows the import of an existing dynamic vars
profile in json format. This is a quick and convenient way to set up
the workflow, alternative to specifying lookup tables manually through
the corresponding setter functions. For more details,
refer to the dedicated vignette
\code{vignette("workflow_start", package="ISAnalytics")}.
}
\examples{
tmp_folder <- tempdir()
export_ISA_settings(tmp_folder, "DEFAULT")
import_ISA_settings(fs::path(tmp_folder, "DEFAULT_ISAsettings.json"))
reset_dyn_vars_config()
}
\seealso{
Other Utilities: 
\code{\link{as_sparse_matrix}()},
\code{\link{comparison_matrix}()},
\code{\link{enable_progress_bars}()},
\code{\link{export_ISA_settings}()},
\code{\link{generate_Vispa2_launch_AF}()},
\code{\link{generate_blank_association_file}()},
\code{\link{generate_default_folder_structure}()},
\code{\link{separate_quant_matrices}()},
\code{\link{transform_columns}()}
}
\concept{Utilities}
