% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{gene_frequency_fisher}
\alias{gene_frequency_fisher}
\title{Compute Fisher's exact test on gene frequencies.}
\usage{
gene_frequency_fisher(
  cis_x,
  cis_y,
  min_is_per_gene = 3,
  gene_set_method = c("intersection", "union"),
  onco_db_file = "proto_oncogenes",
  tumor_suppressors_db_file = "tumor_suppressors",
  species = "human",
  known_onco = known_clinical_oncogenes(),
  suspicious_genes = clinical_relevant_suspicious_genes(),
  significance_threshold = 0.05,
  remove_unbalanced_0 = TRUE
)
}
\arguments{
\item{cis_x}{A data frame obtained via \code{CIS_grubbs()}}

\item{cis_y}{A data frame obtained via \code{CIS_grubbs()}}

\item{min_is_per_gene}{Used for pre-filtering purposes. Genes with a
number of distinct integration less than this number will be filtered out
prior calculations. Single numeric or integer.}

\item{gene_set_method}{One between "intersection" and "union". When merging
the 2 data frames, \code{intersection} will perform an inner join operation,
while \code{union} will perform a full join operation.}

\item{onco_db_file}{Uniprot file for proto-oncogenes (see details).
If different from default, should be supplied as a path to a file.}

\item{tumor_suppressors_db_file}{Uniprot file for tumor-suppressor genes.
If different from default, should be supplied as a path to a file.}

\item{species}{One between \code{"human"}, \code{"mouse"} and \code{"all"}}

\item{known_onco}{Data frame with known oncogenes. See details.}

\item{suspicious_genes}{Data frame with clinical relevant suspicious
genes. See details.}

\item{significance_threshold}{Significance threshold for the Fisher's
test p-value}

\item{remove_unbalanced_0}{Remove from the final output those pairs in
which there are no IS for one group or the other and the number of
IS of the non-missing group are less than the mean number of IS for that
group}
}
\value{
A data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Provided 2 data frames with calculations for CIS, via \code{CIS_grubbs()},
computes Fisher's exact test.
Results can be plotted via \code{fisher_scatterplot()}.
}
\details{
\subsection{Oncogene and tumor suppressor genes files}{

These files are included in the package for user convenience and are
simply UniProt files with gene annotations for human and mouse.
For more details on how this files were generated use the help
\code{?tumor_suppressors}, \code{?proto_oncogenes}
}

\subsection{Known oncogenes}{

The default values are included in this package and
it can be accessed by doing:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{known_clinical_oncogenes()

}\if{html}{\out{</div>}}

If the user wants to change this parameter the input data frame must
preserve the column structure. The same goes for the \code{suspicious_genes}
parameter (DOIReference column is optional):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{clinical_relevant_suspicious_genes()

}\if{html}{\out{</div>}}
}
}
\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item gene_symbol
}
}

\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
cis <- CIS_grubbs(aggreg, by = "SubjectID")
fisher <- gene_frequency_fisher(cis$cis$PT001, cis$cis$PT002,
    min_is_per_gene = 2
)
fisher
}
\seealso{
Other Analysis functions: 
\code{\link{CIS_grubbs}()},
\code{\link{HSC_population_size_estimate}()},
\code{\link{compute_abundance}()},
\code{\link{cumulative_is}()},
\code{\link{is_sharing}()},
\code{\link{iss_source}()},
\code{\link{sample_statistics}()},
\code{\link{top_integrations}()},
\code{\link{top_targeted_genes}()}
}
\concept{Analysis functions}
