% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{comparison_matrix}
\alias{comparison_matrix}
\title{Obtain a single integration matrix from individual quantification
matrices.}
\usage{
comparison_matrix(
  x,
  fragmentEstimate = "fragmentEstimate",
  seqCount = "seqCount",
  barcodeCount = "barcodeCount",
  cellCount = "cellCount",
  ShsCount = "ShsCount",
  value_col_name = "Value"
)
}
\arguments{
\item{x}{A named list of integration matrices, ideally obtained via
\link{import_parallel_Vispa2Matrices}. Names must be
quantification types in \code{quantification_types()}.}

\item{fragmentEstimate}{The name of the output column for fragment
estimate values}

\item{seqCount}{The name of the output column for sequence
count values}

\item{barcodeCount}{The name of the output column for barcode count
values}

\item{cellCount}{The name of the output column for cell count values}

\item{ShsCount}{The name of the output column for Shs count values}

\item{value_col_name}{Name of the column containing the corresponding
values in the single matrices}
}
\value{
A single data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Takes a list of integration matrices referring to different quantification
types and merges them into a single data frame with multiple
value columns, each renamed according to their quantification type
of reference.
}
\examples{
sc <- tibble::tribble(
    ~chr, ~integration_locus, ~strand, ~CompleteAmplificationID, ~Value,
    "1", 45324, "+", "ID1", 543,
    "2", 52423, "-", "ID1", 42,
    "6", 54623, "-", "ID2", 67,
    "X", 12314, "+", "ID3", 8
)
fe <- tibble::tribble(
    ~chr, ~integration_locus, ~strand, ~CompleteAmplificationID, ~Value,
    "1", 45324, "+", "ID1", 56.76,
    "2", 52423, "-", "ID1", 78.32,
    "6", 54623, "-", "ID2", 123.45,
    "X", 12314, "+", "ID3", 5.34
)
comparison_matrix(list(
    fragmentEstimate = fe,
    seqCount = sc
))
}
\seealso{
\link{quantification_types}

Other Utilities: 
\code{\link{as_sparse_matrix}()},
\code{\link{enable_progress_bars}()},
\code{\link{export_ISA_settings}()},
\code{\link{generate_Vispa2_launch_AF}()},
\code{\link{generate_blank_association_file}()},
\code{\link{generate_default_folder_structure}()},
\code{\link{import_ISA_settings}()},
\code{\link{separate_quant_matrices}()},
\code{\link{transform_columns}()}
}
\concept{Utilities}
