% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich_results.R
\name{.enrich_res}
\alias{.enrich_res}
\title{Compute gene set enrichment estimates with standard errors.}
\usage{
.enrich_res(sig_lev, pprobs, d_vec, SE_type = "NDS", boot_rep = NULL)
}
\arguments{
\item{sig_lev}{A significance threshold for gene set enrichment hypothesis
testing.}

\item{pprobs}{A vector of posterior probabilities for each gene estimated
from the
intact function. Gene order should match d_vec.}

\item{d_vec}{A vector of gene set annotations for the genes of interest.
Entries should be integer(1) if the gene is annotated and integer(0)
otherwise.}

\item{SE_type}{A method to compute standard errors of the gene set enrichment
 estimates.
Possible methods are "profile_likelihood," "bootstrap," and "NDS". NDS
performs numerical
 differentiation of the Fisher score vector.}

\item{boot_rep}{Number of bootstrap samples, if boostrap standard errors are
specified
for SE_type.}
}
\value{
A data frame with the alpha1 estimate, standard error, z-score,
p-value,
(1-sig_lev)\% CI limits, and convergence indicator.
}
\description{
Compute gene set enrichment estimates with standard errors.
}
