% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Extract-methods.R
\name{removeModel}
\alias{removeModel}
\alias{removeModel,INSPEcT-method}
\title{remove modelling information from INSPEcT object}
\usage{
removeModel(object)

\S4method{removeModel}{INSPEcT}(object)
}
\arguments{
\item{object}{An Object of class INSPEcT}
}
\value{
An Object of class INSPEcT
}
\description{
Remove the model from an INSPEcT object. It is required when subsetting
an INSPEcT object per time points because when removing time points
the modeling is not valid anymore.
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
nascentInspObj10_5genes <- nascentInspObj10[1:5]

## This will turn out into an error:
\dontrun{nascentInspObj10_5genes_5tpts <- nascentInspObj10[1:5, 1:5]
}

## Before subsetting time points, the model should be removed:
nascentInspObj10_5genes_5tpts <- removeModel(nascentInspObj10)[1:5, 1:5]

## Also this will turn out into an error:
\dontrun{nascentInspObj10 <- modelRates(nascentInspObj10)}

## Before running the model again, or changing modeling parameters,
## the previous model should be removed:
nascentInspObj10_old <- nascentInspObj10
nascentInspObj10_new <- removeModel(nascentInspObj10)
\dontrun{nascentInspObj10_new <- modelRates(nascentInspObj10_new, useSigmoidFun = FALSE)}
}
