% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steady-state-methods.R
\name{plotMA}
\alias{plotMA}
\alias{plotMA,INSPEcT_diffsteady-method}
\title{MA-plot from base means and log fold changes}
\usage{
\S4method{plotMA}{INSPEcT_diffsteady}(object, ...)
}
\arguments{
\item{object}{An object of calss INSPEcT_diffsteady}

\item{...}{Additional parameters, see Details section}
}
\description{
Visualize the comparison between the rates calculated from two different INSPEcT objects
profiled in steady-state conditions.
}
\details{
Possible arguments to "plotMA":
\itemize{
\item "rate" - A character, which represent the rate to be visualized, either "synthesis", "processing" or "degradation". By default, "synthesis" is chosen.
\item "padj" - A numeric, The p-adjusted threshold for significance. Genes with p-adjusted lower than the threshold will be depicted as orange triangles. By default set to -Inf, meaning that no genes will be highlighted.
\item "xlim" - A numeric vector of length 2, limits of x-axis, by default the range of the data.
\item "xlab" - A character, the label of x-axis, by default "log2 geometric mean"
\item "ylim" - A numeric vector of length 2, limits of y-axis, by default the range of the data.
\item "ylab" - A character, the label of y-axis, by default "log2 fold change"
\item "main" - A character, the title of the plot, by default the name of the visualized rate.
}
}
\examples{
if( Sys.info()["sysname"] != "Windows" ) {
  data('allcounts', package='INSPEcT')
  data('featureWidths', package='INSPEcT')
  data('libsizes', package='INSPEcT')
  
  nascentCounts<-allcounts$nascent
  matureCounts<-allcounts$mature
  conditions<-letters[1:11]
  expDes<-rep(conditions,3)
  tL<-1/6
  
  nasExp_DESeq2<-quantifyExpressionsFromTrCounts(
        allcounts=nascentCounts
        ,libsize=nascentLS
        ,exonsWidths=exWdths
        ,intronsWidths=intWdths
        ,experimentalDesign=expDes)
  
  matExp_DESeq2<-quantifyExpressionsFromTrCounts(
        allcounts=matureCounts
        ,libsize=totalLS
        ,exonsWidths=exWdths
        ,intronsWidths=intWdths
        ,experimentalDesign=expDes)
 
  nasFullObj <- newINSPEcT(tpts=conditions
        ,labeling_time=tL
        ,nascentExpressions=nasExp_DESeq2
        ,matureExpressions=matExp_DESeq2)
  
  diffrates = compareSteady(nasFullObj[,c(1,11)])
 
  plotMA(diffrates, padj=.01)
}
}
\seealso{
\url{http://en.wikipedia.org/wiki/MA_plot}
}
