% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/show-methods.R
\docType{class}
\name{INSPEcT_model-class}
\alias{INSPEcT_model-class}
\alias{show,INSPEcT_model-method}
\title{An S4 class to represent models generated by INSPEcT}
\usage{
\S4method{show}{INSPEcT_model}(object)
}
\arguments{
\item{object}{An object of class INSPEcT_model}
}
\value{
Method show for objects of class INSPEcT_model returns the number of
the genes that have been modeled
}
\description{
INSPEcT_model is a class able to store all the results of the modeling of synthesis, processing and degradation rates made via the method \code{\link{modelRates}} (slot ratesSpecs).
It also stores the criteria (slot parameter) to choose between the many models tested for each gene the one that better describes the data and the results. 
The slot simple is a flag that distinguish wheter the model contains the information of the introns or not.
In case not, the flag simple is set to TRUE. 
Also the method \code{\link{makeSimModel}} of class \code{\link{INSPEcT-class}} creates an object of class INSPEcT_model. 
This object will be used by \code{\link{makeSimDataset}} to generate a complete simulated data-set, whose classification performance can be tested.
}
\details{
Methods that apply to INSPEcT_model class are
\code{\link[=Extract]{[}} \cr
\code{\link{AIC}} \cr
\code{\link{chisqtest}} \cr
\code{\link{correlationPlot}} \cr
\code{\link{geneClass}} \cr
\code{\link{logLik}} \cr
\code{\link{makeModelRates}} \cr
\code{\link{makeSimDataset}} \cr
\code{\link{modelSelection}} \cr
\code{\link{rocCurve}} \cr
\code{\link{rocThresholds}} \cr
\code{\link{show}} \cr
}
\section{Slots}{

\describe{
\item{\code{params}}{A list that defines thresholds and how to perform log likelihood ratio tests}

\item{\code{ratesSpecs}}{A list containing the modeling output}

\item{\code{simple}}{A logical that indicates whether the mode of INSPEcT is simple (no pre-mRNA and degradation rates) or not.}
}}

