% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{LogisticRegression}
\alias{LogisticRegression}
\title{Clustering projection using logistic regression from
the LiblineaR R package}
\usage{
LogisticRegression(
  training.sparse.matrix = NULL,
  training.ident = NULL,
  C = 0.3,
  reg.type = "L1",
  test.sparse.matrix = NULL,
  d = 0.3
)
}
\arguments{
\item{training.sparse.matrix}{A sparse matrix (dgCMatrix) containing training
sample's gene expression data with genes in rows and cells in columns.
Default is \code{NULL}.}

\item{training.ident}{A named factor containing sample's cluster labels for
each cell in training.sparse.matrix. Default is \code{NULL}.}

\item{C}{Cost of constraints violation in L1-regularized logistic
regression (C). Default is \code{0.3}.}

\item{reg.type}{"L1" for LASSO and "L2" for Ridge. Default is "L1".}

\item{test.sparse.matrix}{A sparse matrix (dgCMatrix) containing test
sample's gene expression data with genes in rows and cells in columns.
Default is \code{NULL}.}

\item{d}{A numeric smaller than \code{1} and greater than \code{0}
that determines how many cells per cluster should be
down- and oversampled (d in N/k*d), where N is the total number of cells
and k the number of clusters. Default is \code{0.3}.}
}
\value{
a list containing the output of the LiblineaR prediction
}
\description{
The function implements a script that downsamples data a dataset, trains
a logistic regression classifier model
and then projects its clustering onto itself using a trained
L1-regularized logistic regression model.
}
\keyword{LiblineaR}
\keyword{downsampling}
\keyword{logistic}
\keyword{oversampling}
\keyword{projection}
\keyword{regression}
