% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMetaboLights.R
\name{getMetaboLights}
\alias{getMetaboLights}
\alias{getMetaboLightsFile}
\title{Get metabolomic data from MetaboLights database}
\usage{
getMetaboLights(study.id, output = "list", ...)

getMetaboLightsFile(study.id, file, ...)
}
\arguments{
\item{study.id}{\code{character vector} specifying the study identifier of
data that is going to be fetched from the MetaboLights database.}

\item{output}{\code{character scalar} specifying output format. Must be
\code{"list"}, \code{"TreeSE"} (\code{TreeSummarizedExperiment}) or
\code{"SE"} (\code{SummarizedExperiment}). (Default: \code{"list"})}

\item{...}{optional arguments:
\itemize{

  \item \strong{cache.dir} \code{Character scalar} specifying directory
  where downloaded file is stored. (Default: \code{tempdir()})

  \item \strong{timeout} \code{Integer scalar} specifying timeout
  in seconds for loading a file. (Default: \code{5*60})

  \item \strong{ion.mode} \code{Character scalar} specifying metabolite
  assignment files to fetch. If \code{"positive"} only positive ions are
  fetched. Similarly \code{"negative"} means that negative ions are fetched
  if such data exists. By selecting \code{"both"}, one can fetch both
  positive and negative ions. (Default: \code{"both"})

}}

\item{file}{\code{character vector} specifying the files that are being
fetched.}
}
\value{
\code{list}, \code{SummarizedExperiment} or
\code{TreeSummarizedExperiment}
}
\description{
Get metabolomic data from MetaboLights database
}
\details{
The HoloFood database primarily comprises targeted metabolomic data,
omitting non-targeted metabolomic information. Nonetheless, it features URLs
linking to studies within the MetaboLights database. This functionality
enables users to access non-targeted metabolomic data. The
\code{getMetaboLights} function returns
a structured list encompassing processed data in \code{data.frame} format
for study metadata, assay metadata, and assay.

The metadata includes the file names of spectra data. Those files can be
loaded with \code{getMetaboLightsFile}. Alternatively, once you've identified
the study and files to fetch, you can refer to this
[vignette](https://rformassspectrometry.github.io/MsIO/articles/MsIO.html#loading-data-from-metabolights)
for instructions on loading the data directly into an \code{MsExperiment}
object, specifically designed for metabolomics spectra data.
}
\examples{

# This example is not run, because the server fails to respond sometimes.
if( FALSE ){
    res <- getMetaboLights("MTBLS4381")
    file_paths <- getMetaboLightsFile(
        study.id = "MTBLS4381",
        file = res[["assay_meta"]][["Raw Spectral Data File"]]
        )
    # Get data as SummarizedExperiment
    se <- getMetaboLights("MTBLS3540", output = "SE")
}

}
\seealso{
\code{\link[HoloFoodR:getResult]{getResult}}
\code{\link[HoloFoodR:getData]{getData}}
}
