% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareMtxList.R
\name{PrepareMtxList}
\alias{PrepareMtxList}
\title{Prepare matrices list for further analysis.}
\usage{
PrepareMtxList(
  matrices,
  minDist = NULL,
  maxDist = NULL,
  rm0 = FALSE,
  transFun = NULL,
  orientate = FALSE
)
}
\arguments{
\item{matrices}{<list\link{matrix}>: The matrices list to prepare.}

\item{minDist}{\if{html}{\out{<numeric>}}: The minimal distance between anchor
and bait.}

\item{maxDist}{\if{html}{\out{<numeric>}}: The maximal distance between anchor
and bait.}

\item{rm0}{\if{html}{\out{<logical>}}: Whether 0 should be replaced with NA.
(Default FALSE)}

\item{transFun}{\if{html}{\out{<function or chracter>}}: The function used to
transform or scale values in each submatrix before aggregation.
The following characters can be submitted:
\itemize{
\item "quantile" or "qtl" apply function dplyr::ntile(x,500)
\item "percentile" or "prct" apply percentile.
\item "rank" apply a ranking.
\item "zscore" apply a scaling.
\item "minmax" scales on a min to max range.
\item "mu" scales on mean: \code{(x-mean(x))/(max(x)-min(x))}.
\item other or NULL don't apply transformation (Default).
}}

\item{orientate}{\if{html}{\out{<logical>}}: Whether matrices must be
corrected for orientatation before the aggregation.}
}
\value{
A matrix list ready for aggregation of values extraction.
}
\description{
Prepares matrices list for further analysis
(eg. Aggregation or GetQuantif). Orientation can be corrected,
and per matrix transformation can be performed.
}
\details{
PrepareMtxList
}
\examples{
# Data
data(Beaf32_Peaks.gnr)
data(HiC_Ctrl.cmx_lst)
data(HiC_HS.cmx_lst)

# Index Beaf32
Beaf32_Index.gnr <- IndexFeatures(
    gRangeList = list(Beaf = Beaf32_Peaks.gnr),
    chromSizes = data.frame(seqnames = c("2L", "2R"),
          seqlengths = c(23513712, 25286936)),
    binSize = 100000
)

# Beaf32 <-> Beaf32 Pairing
Beaf_Beaf.gni <- SearchPairs(indexAnchor = Beaf32_Index.gnr)
Beaf_Beaf.gni <- Beaf_Beaf.gni[seq_len(2000)] # subset 2000 first for exemple

# Matrices extractions center on Beaf32 <-> Beaf32 point interaction
interactions_Ctrl.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_Ctrl.cmx_lst,
    referencePoint = "pf"
)
interactions_HS.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_HS.cmx_lst,
    referencePoint = "pf"
)
interactions_Ctrl.mtx_lst <- PrepareMtxList(
    matrices = interactions_Ctrl.mtx_lst
)

# Aggregate matrices in one matrix
aggreg.mtx <- Aggregation(interactions_Ctrl.mtx_lst)


interactions_HS.mtx_lst <- PrepareMtxList(
    matrices = interactions_HS.mtx_lst
)

# Differential Aggregation
aggregDiff.mtx <- Aggregation(
    ctrlMatrices = interactions_Ctrl.mtx_lst,
    matrices = interactions_HS.mtx_lst
)

}
