% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractSubmatrix.R
\name{ExtractSubmatrix}
\alias{ExtractSubmatrix}
\title{Submatrix extraction.}
\usage{
ExtractSubmatrix(
  genomicFeature = NULL,
  hicLst = NULL,
  referencePoint = "pf",
  hicResolution = NULL,
  matriceDim = 21,
  shift = 1,
  remove_duplicates = TRUE,
  cores = 1,
  verbose = FALSE
)
}
\arguments{
\item{genomicFeature}{<GRanges or Pairs\link{GRanges} or GInteractions>:
The genomic coordinates on which compute the extraction of HiC submatrix.}

\item{hicLst}{<List\link[InteractionSet:ContactMatrix-class]{ContactMatrix}>:
The HiC maps list.}

\item{referencePoint}{\if{html}{\out{<character>}}: Type of
extracted submatrices. "rf" for "region feature" to extract triangle-shaped
matrices around regions or "pf" for "point feature" to extract
square-shaped matrices around points. (Default "rf")}

\item{hicResolution}{\if{html}{\out{<numeric>}}: The resolution
used in hicLst. If \code{NULL}, automatically find in resolution attributes
of hicLst. (Default NULL)}

\item{matriceDim}{\if{html}{\out{<numeric>}}: The size of matrices in output.
(Default 21).}

\item{shift}{\if{html}{\out{<numeric>}}: Only when "referencePoint" is "rf".
Factor defining how much of the distance between anchor and bait is
extracted before and after the region (Default 1).
Ex: for shift=2, extracted matrices will be:
\code{2*regionSize+regionSize+2*regionSize}.}

\item{remove_duplicates}{\if{html}{\out{<Logical>}}:
remove duplicated submatrices ?
This avoids duplicated submatrices when both anchor and bait bins are from
the same feature. ex. BEAF32-BEAF32, same submatrix twice with opposite
orientations(Default TRUE)}

\item{cores}{\if{html}{\out{<integer>}} : An integer
to specify the number of cores. (Default 1)}

\item{verbose}{\if{html}{\out{<logical>}}: If TRUE,
show the progression in console. (Default FALSE)}
}
\value{
A matrices list.
}
\description{
Extract matrices in the HiC maps list around genomic features.
}
\details{
ExtractSubmatrix
}
\examples{
# Data
data(Beaf32_Peaks.gnr)
data(HiC_Ctrl.cmx_lst)

# Index Beaf32
Beaf32_Index.gnr <- IndexFeatures(
    gRangeList = list(Beaf = Beaf32_Peaks.gnr),
    chromSizes = data.frame(seqnames = c("2L", "2R"),
        seqlengths = c(23513712, 25286936)),
    binSize = 100000
)

# Beaf32 <-> Beaf32 Pairing
Beaf_Beaf.gni <- SearchPairs(indexAnchor = Beaf32_Index.gnr)
Beaf_Beaf.gni <- Beaf_Beaf.gni[seq_len(2000)] # subset 2000 first for exemple

# Matrices extractions of regions defined between
# Beaf32 <-> Beaf32 interactions
interactions_RF.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_Ctrl.cmx_lst,
    referencePoint = "rf"
)

# Matrices extractions center on Beaf32 <-> Beaf32 pointinteraction
interactions_PF.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_Ctrl.cmx_lst,
    referencePoint = "pf"
)


}
