% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_plot.R
\name{pmBarplot}
\alias{pmBarplot}
\title{Plot both mutation signatures and their mutational exposures from
pmsignature output}
\usage{
pmBarplot(
  inputG,
  inputParam,
  sigOrder = NULL,
  refGroup = NULL,
  sortSampleNum = TRUE,
  refName = "Control",
  altName = "Case",
  charSize = 3
)
}
\arguments{
\item{inputG}{a MutationFeatureData S4 class output by the pmsignature.}

\item{inputParam}{a estimatedParameters S4 class output by the pmsignature.}

\item{sigOrder}{the order of signatures if needed (default: NULL).}

\item{refGroup}{the samples in the reference group (default: NULL).}

\item{sortSampleNum}{whether to sort by number of mutations (default: TRUE).}

\item{refName}{the name of reference group (default: Control).}

\item{altName}{the name of the other group (default: Case).}

\item{charSize}{the size of the character on the signature plot (default: 3).}
}
\value{
a list of a signature plot and a barplot of mutational exposures
}
\description{
Plot both mutation signatures and their mutational exposures from
pmsignature output
}
\examples{

load(system.file("extdata/sample.rdata", package="HiLDA"))
Param <- pmgetSignature(G, K = 3)

pmPlots <- pmBarplot(G, Param, refGroup=1:4)
cowplot::plot_grid(pmPlots$sigPlot, pmPlots$propPlot, rel_widths = c(1,3))


}
