% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hic_diff.R
\name{hic_diff}
\alias{hic_diff}
\title{Detect differences between two jointly normalized Hi-C datasets. OLD METHOD; USE hic_compare() instead}
\usage{
hic_diff(
  hic.table,
  diff.thresh = "auto",
  iterations = 10000,
  Plot = FALSE,
  Plot.smooth = TRUE,
  parallel = FALSE,
  BP_param = bpparam()
)
}
\arguments{
\item{hic.table}{A hic.table or list of hic.tables output from the
\code{hic_loess} function. hic.table must be jointly normalized
before being entered.}

\item{diff.thresh}{Fold change threshold desired to call a detected
difference significant. Set to 'auto' by default to indicate that the
difference threshold will be automatically calculated as 2 standard
deviations of all the adjusted M values. For no p-value adjustment
set diff.thresh = NA. To set your own threshold enter a numeric value
i.e. diff.thresh = 1. If set to 'auto' or a numeric value, a check will
be made as follows: if permutation p-value < 0.05 AND M < diff.thresh (the log2
fold change for the difference between IF1 and IF2) then
the p-value will be set to 0.5.}

\item{iterations}{Number of iterations for the permuation test.}

\item{Plot}{Logical, should the MD plot showing before/after loess normalization
be output?}

\item{Plot.smooth}{Logical, defaults to TRUE indicating the MD plot
will be a smooth scatter plot. Set to FALSE for a scatter plot
with discrete points.}

\item{parallel}{Logical, set to TRUE to utilize the \code{parallel} package's
parallelized computing. Only works on unix operating systems. Only useful if
entering a list of hic.tables.}

\item{BP_param}{Parameters for BiocParallel. Defaults to bpparam(), see help
for BiocParallel for more information
\url{http://bioconductor.org/packages/release/bioc/vignettes/BiocParallel/
inst/doc/Introduction_To_BiocParallel.pdf}}
}
\value{
A hic.table with additional columns containing a p-value for the significance
    of the difference and the raw fold change between the IFs of the two datasets.
}
\description{
Detect differences between two jointly normalized Hi-C datasets. OLD METHOD; USE hic_compare() instead
}
\details{
This is the old method for detecting difference. The function is left in for 
    legacy reasons and 
    it is recommended to use the new function, hic_compare(), instead.
    The function takes in a hic.table or a list of hic.table objects created
    with the \code{hic_loess} function. If you wish to perform difference
    detection on Hi-C data for multiple chromosomes use a list of hic.tables. The process
    can be parallelized using the \code{parallel}
    setting. The adjusted IF and adjusted M calculated from \code{hic_loess} are used for
    difference detection. A permutation test is performed to test
    the significance of the difference between each IF of the two datasets. Permutations
    are broken in blocks for each unit distance. See methods section
    of Stansfield & Dozmorov 2017 for more details.
}
\examples{
# Create hic.table object using included Hi-C data in sparse upper triangular
# matrix format
data('HMEC.chr22')
data('NHEK.chr22')
hic.table <- create.hic.table(HMEC.chr22, NHEK.chr22, chr = 'chr22')
# Plug hic.table into hic_loess()
result <- hic_loess(hic.table, Plot = TRUE)
# perform difference detection
diff.result <- hic_diff(result, diff.thresh = 'auto', Plot = TRUE)

}
