% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_transformations.R
\name{cooler2sparse}
\alias{cooler2sparse}
\title{Transform a .cool file to a sparse upper triangular matrix for input into
    hic_loess}
\usage{
cooler2sparse(cooler)
}
\arguments{
\item{cooler}{The plain text file from a .cool file loaded into an R
data.frame object. See vignette for more details.}
}
\value{
A Sparse upper triangular matrix or a list of sparse upper triangular matrices.
    If the .cool file contains data for more than one chromosome
    The function will split the data up into a list of matrices, one per chromosome.
}
\description{
Transform a .cool file to a sparse upper triangular matrix for input into
    hic_loess
}
\details{
The .cool format is linked a database of Hi-C experiments and
    allows access to many sets of Hi-C data which can be found
    at the Index of Coolers  \url{ftp://cooler.csail.mit.edu/coolers}. Once a .cool
    file is dumped into a contact matrix in plain text it can be
    read into R.  This function provides a method for converting the .cool matrix
    into a sparse upper triangular matrix ready to be entered into
    hic_loess.
}
\examples{
data('cooler')
sparse <- cooler2sparse(cooler)
head(sparse)
}
