% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cournac_normalization.R
\name{SCN}
\alias{SCN}
\title{SCN normalization from Cournac 2012}
\usage{
SCN(a, max.iter = 10)
}
\arguments{
\item{a}{The matrix to be normalized. Any cols/rows that sum to
0 will be removed before normalization.}

\item{max.iter}{maximum number of iterations to be performed}
}
\value{
An SCN normalized matrix
}
\description{
SCN normalization from Cournac 2012
}
\details{
Performs Sequential Component Normalization as described by
    Cournac. Coded using details in the manuscript.
    Cournac A, Marie-Nelly H, Marbouty M, Koszul R, Mozziconacci J.
    Normalization of a chromosomal contact map.
    BMC Genomics. 2012;13: 436. doi:10.1186/1471-2164-13-436
}
\examples{
m <- matrix(rpois(100, 5), 10, 10)
SCN(m)
}
