% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_interactions.R
\name{load_interactions}
\alias{load_interactions}
\title{Loads interaction file into GenomicInteractions Object}
\usage{
load_interactions(file, sep = "\\t", ...)
}
\arguments{
\item{file}{full path to the interaction file (seqmonk, ibed, washU)}

\item{sep}{separator to read the file}

\item{...}{arguments to pass to \link[HiCaptuRe]{digest_genome}}
}
\value{
HiCaptuRe object
}
\description{
This function loads interaction files from Chicago R package into a GenomicInteractions Object, and remove possible duplicated interactions
}
\examples{
ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions <- load_interactions(ibed1, select_chr = "19")

}
