% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{getters}
\alias{getters}
\alias{getParameters}
\alias{getParameters,HiCaptuRe-method}
\alias{getByBaits}
\alias{getByBaits,HiCaptuRe-method}
\alias{getByRegions}
\alias{getByRegions,HiCaptuRe-method}
\title{Internal functions to access data held in a HiCaptuRe object.}
\usage{
getParameters(x)

\S4method{getParameters}{HiCaptuRe}(x)

getByBaits(x)

\S4method{getByBaits}{HiCaptuRe}(x)

getByRegions(x)

\S4method{getByRegions}{HiCaptuRe}(x)
}
\arguments{
\item{x}{A HiCaptuRe object}
}
\value{
\describe{
  \item{getParameters(x)}{A named list of named vectors with all parameters used.}
  \item{getByBaits(x)}{A list of tibbles with bait‑centric summaries.}
  \item{getByRegions(x)}{A list of `GRanges` with region‑centric summaries.}
}
}
\description{
Use these functions to access data stored in each of the slots of a
HiCapture object.
}
\examples{
ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions <- load_interactions(ibed1, select_chr = "19")
getParameters(interactions)

baits <- c("ENST00000332235", "ENST00000516525")
interactions_baits <- interactionsByBaits(interactions = interactions, baits = baits)
getByBaits(interactions_baits)

regions <- GenomicRanges::GRanges(seqnames = 19, ranges = IRanges::IRanges(start = c(500000, 1000000), end = c(510000, 1100000)))
interactions_regions <- interactionsByRegions(interactions = interactions, regions = regions)
getByRegions(interactions_regions)

}
